/*
 * main.cpp
 *
 * Testing application to show off smart pointers.  Notice how they use reference counting.
 *
 * Walker M. White
 * February 6, 2015
 */

#include <stdio.h>
#include <memory>
#include "point.h"

using namespace std;

/**
 * A function with its own objects
 * 
 * @param obj An external object
 */ 
void func1(shared_ptr<Point> obj) {
	printf("Reference count of %s is %ld\n",obj->toString().c_str(),obj.use_count());
	shared_ptr<Point> other = make_shared<Point>(4.0f,5.0f,6.0f);
	obj->x += 1;
}

/**
 * A function with its own objects
 * 
 * @param obj An external object
 */ 
void func2(const shared_ptr<Point>& obj) {
	printf("Reference count of %s is %ld\n",obj->toString().c_str(),obj.use_count());
	auto other = std::make_shared<Point>(7.0f,8.0f,9.0f);
	obj->x -= 1;
}


/**
 * Main application function.
 */
int main() {
	shared_ptr<Point> p = make_shared<Point>(1.0f,2.0f,3.0f);
	printf("Reference count of %s is %ld\n",p->toString().c_str(),p.use_count());
	shared_ptr<Point> q = p;
	printf("Reference count of %s is %ld\n",p->toString().c_str(),p.use_count());

	func1(p);	
	func2(p);
	
	printf("Reassigning p\n");
	p = make_shared<Point>(0.0f,0.0f,0.0f);
	printf("Reassigning q\n");
	q = nullptr;
	printf("Reassignment finished\n");
	
	
	return 0;
}
