/*
 * a.h
 *
 * This is a template class to show off how they work.
 *
 * Templates never have an associated CPP file.  That is because the class is not
 * created until you fill in the type details, which happens at allocation.  However,
 * a template can extended a non-templated class, which might be in a CPP file.  In 
 * fact, that is a standard design pattern: put non-templated methods in a non-templated
 * base class and make the templated parts the subclass.
 *
 * Walker M. White
 * February 6, 2015
 */
 
// Prevent cyclical includes
#ifndef __A__H_ 
#define __A__H_
#include <typeinfo>
#include <type_traits>
#include <string>


/**
 * This is the template declaration.
 *
 * Note the template keyword.  At compile time, this is replaced by the type.
 */
template <typename T>
class A {
private:
	/** The type value */
	T value;
	
public:
		
	/** 
	 * Create a new A object
	 *
	 * We have no defaults, because we do not know what they are.
	 *
	 * @param v  The initial value
	 */
	A(T v) {
		value = v;
	}
	
	/** 
	 * Create a new A object
	 *
	 * This is a copy constructor.  It takes the contents of A and puts them in B.
	 *
	 * @param obj  The object to copy
	 */
	A(const A& obj) {
		value = obj.value;
	}
	
	/**
	 * Returns the T value
	 *
	 * @return the T value
	 */
	const T& getValue() const { return value; }

	/**
	 * Sets the T value
	 *
	 * @param value the T value
	 */
	void setValue(const T& v) { value = v; }

	 /**
	  * Returns a string representation of this object
	  *
	  * @return a string representation of this object
	  */
	std::string toString() {
		std::string tname(typeid(T).name());
		std::string tvalue = std::to_string(value);
		return "Type "+tname+" has value "+tvalue;
	}

}; // DO NOT FORGET THE SEMICOLON!!!


/**
 * This is a SPECIALIZED template declaration.
 *
 * We want to do something different if T is a pointer.  Hence the need of a second
 * template for the same class.
 */
template <typename T>
class A<T*> {
private:
	/** The type value */
	T* value;
	
public:
		
	/** 
	 * Create a new A object
	 *
	 * We have no defaults, because we do not know what they are.
	 *
	 * @param v  The initial value
	 */
	A<T*>(T* v) {
		value = v;
	}
	
	/** 
	 * Create a new A object
	 *
	 * This is a copy constructor.  It takes the contents of A and puts them in B.
	 *
	 * @param obj  The object to copy
	 */
	A<T*>(const A<T*>& obj) {
		value = obj.value;
	}
	
	/**
	 * Returns the T value
	 *
	 * @return the T value
	 */
	const T* const getValue() const { return value; }

	/**
	 * Sets the T value
	 *
	 * @param value the T value
	 */
	void setValue(const T* const v) { value = v; }

	 /**
	  * Returns a string representation of this object
	  *
	  * @return a string representation of this object
	  */
	std::string toString() {
		std::string tname(typeid(T).name());
		std::string tvalue = std::to_string(value->getValue());
		return "Type "+tname+" has value "+tvalue;
	}

}; // DO NOT FORGET THE SEMICOLON!!!
#endif