/*
 * main.cpp
 *
 * Testing application to show off how subclassing works in C++.
 *
 * Subclassing works mostly like you think it does UNTIL you try to use polymorphism.
 * Then you are in for an unpleasant surprise.
 *
 * Walker M. White
 * February 6, 2015
 */
#include <stdio.h>
#include "a.h"
#include "b.h"

/**
 * Test subclasses with stack-based objects.
 *
 * One of the problems with stack-based objects is that you do not get true
 * polymorphism.  If you try to stick an object into a variable of a different
 * type, you will copy the object and lose information.
 */
void test_stack() {
	A a(1,2);
	B b(3,4, 7);
	
	printf("\n");
	printf("a.foo() is %d\n",a.foo());

	printf("\n");
	printf("b.foo() is %d\n",b.foo());

	printf("\n");
	printf("a.bar() is %d\n",a.bar());

	printf("\n");
	printf("b.bar() is %d\n",b.bar());
	
	// What happens here?
	printf("\n");
	A temp = (A)b;
	printf("temp.bar() is %d\n",temp.bar());

	printf("\n");
	printf("a.duh() is %d\n",a.duh());

	printf("\n");
	printf("b.duh() is %d\n",b.duh());

	// What happens here?
	printf("\n");
	printf("temp.duh() is %d\n",temp.duh());

	printf("\n");
}

/**
 * Test subclasses with heap-based objects.
 *
 * One of the problems with heap-based objects is that method dispatch does not
 * work the way you think it does.  Unless you use the keyword "virtual", the
 * method is determined by the type, not the object.
 */
void test_heap() {
	A* a = new A(1,2);
	B* b = new B(3,4, 7);
	
	printf("\n");
	printf("a->foo() is %d\n",a->foo());

	printf("\n");
	printf("b->foo() is %d\n",b->foo());

	printf("\n");
	printf("a.bar() is %d\n",a->bar());

	printf("\n");
	printf("b->bar() is %d\n",b->bar());
	
	// What happens here?
	printf("\n");
	A* temp = (A*)b;
	printf("temp->bar() is %d\n",temp->bar());

	printf("\n");
	printf("a->duh() is %d\n",a->duh());

	printf("\n");
	printf("b->duh() is %d\n",b->duh());

	// What happens here?
	printf("\n");
	printf("temp->duh() is %d\n",temp->duh());

	printf("\n");
}

/**
 * Test subclasses with pointers on stack-based objects.
 *
 * The problem with heap-based objects is the fact that you are using pointers.
 * It has nothing to do with the heap.  We show that here.
 */
void test_ptr() {
	A a(1,2);
	B b(3,4, 7);
	
	printf("\n");
	printf("a.foo() is %d\n",a.foo());

	printf("\n");
	printf("b.foo() is %d\n",b.foo());

	printf("\n");
	printf("a.bar() is %d\n",a.bar());

	printf("\n");
	printf("b.bar() is %d\n",b.bar());
	
	// What happens here?
	printf("\n");
	A* temp = (A*)(&b);
	printf("temp.bar() is %d\n",temp->bar());

	printf("\n");
	printf("a.duh() is %d\n",a.duh());

	printf("\n");
	printf("b.duh() is %d\n",b.duh());

	// What happens here?
	printf("\n");
	printf("temp.duh() is %d\n",temp->duh());

	printf("\n");
}


/**
 * Main application function.
 */
int main() {
	test_stack();
	//test_heap();
	//test_ptr();
	return 0;
}