/*
 * b.h
 *
 * This is an example of a subclass in C++.
 *
 * Subclassing works mostly like you think it does UNTIL you try to use polymorphism.
 * Then you are in for an unpleasant surprise.
 *
 * Walker M. White
 * February 6, 2015
 */ 
// Prevent cyclical includes
#ifndef __B__H_ 
#define __B__H_

// We MUST include the superclass in the header
#include "a.h"

/**
 * This is the class declaration.
 *
 * It looks like an interface in Java.  It has no implementations for any of the
 * methods. However, there are significant differences, like the fact that it 
 * also contains the field declarations.
 */
class B : public A {
protected:
	/** The z-coordinate */
	float z;
	
public:
		
	/** 
	 * Create a new B object
	 *
	 * Note the use of default parameters.
	 *
	 * @param x  The initial x-coordinate
	 * @param y  The initial y-coordinate
	 * @param z  The initial z-coordinate
	 */
	B(float x = 0.0f, float y = 0.0f, float z = 0.0f);
	
	/**
	 * Delete an B object
	 *
	 * This is ONLY necessary if the object contains other array, objects, or 
	 * assets that it must delete once it is deleted.
	 */
	 ~B();
	 
	 /**
	  * Silly method that this class will try to override
	  *
	  * The attempt to override will "fail" in a weird way.
	  *
	  * @returns ???
	  */
	int bar();

	 /**
	  * Silly method that this class will try to override
	  *
	  * The attempt to override will succeed this time.
	  *
	  * @returns ???
	  */
	int duh();

}; // DO NOT FORGET THE SEMICOLON!!!

#endif