/*
 * b.cpp
 *
 * This is an example of a subclass in C++.
 *
 * Subclassing works mostly like you think it does UNTIL you try to use polymorphism.
 * Then you are in for an unpleasant surprise.
 *
 * Walker M. White
 * February 6, 2015
 */
#include <stdio.h>
#include "b.h"

/** 
 * Create a new A object
 *
 * Note the use of default parameters.
 *
 * @param x  The initial x-coordinate
 * @param y  The initial y-coordinate
 */
B::B(float x, float y, float z) : A(x,y) {
	printf("Creating B value (%4.2f, %4.2f, %4.2f) @address %p\n", x, y, z, this);
	this->z = z;
}


/**
 * Delete an A object
 *
 * This is ONLY necessary if the object contains other array, objects, or 
 * assets that it must delete once it is deleted.
 */
B::~B() {
	printf("Deleting B value (%4.2f, %4.2f) @address %p\n", x, y, this);
}	 


/**
 * Silly method that this class will try to override
 *
 * The attempt to override will "fail" in a weird way.
 *
 * @returns ???
 */
int B::bar() {
	printf("Invocation of bar() in class B @address %p\n", this);
	return 666;
}


/**
 * Silly method that this class will try to override
 *
 * The attempt to override will succeed this time.
 *
 * @returns ???
 */
int B::duh() {
	printf("Invocation of duh() in class B @address %p\n", this);
	return -10101;
}