/*
 * a.h
 *
 * This is a base class to show off subclassing.
 *
 * Subclassing works mostly like you think it does UNTIL you try to use polymorphism.
 * Then you are in for an unpleasant surprise.
 *
 * Walker M. White
 * February 6, 2015
 */
// Prevent cyclical includes
#ifndef __A__H_ 
#define __A__H_

/**
 * This is the class declaration.
 *
 * It looks like an interface in Java.  It has no implementations for any of the
 * methods. However, there are significant differences, like the fact that it 
 * also contains the field declarations.
 */
class A {
protected:	// Means exactly what you think it means
	/** The x-coordinate */
	float x;
	/** The y-coordinate */
	float y;
	
public:
		
	/** 
	 * Create a new A object
	 *
	 * Note the use of default parameters.
	 *
	 * @param x  The initial x-coordinate
	 * @param y  The initial y-coordinate
	 */
	A(float x = 0.0f, float y = 0.0f);
	
	/** 
	 * Create a new A object
	 *
	 * This is a copy constructor.  It takes the contents of A and puts them in B.
	 *
	 * @param obj  The object to copy
	 */
	A(const A& obj);
	
	/**
	 * Delete an A object
	 *
	 * This is ONLY necessary if the object contains other array, objects, or 
	 * assets that it must delete once it is deleted.
	 */
	 ~A();
	 
	 /**
	  * Silly method that will not be overridden.
	  *
	  * @returns ???
	  */
	int foo();

	 /**
	  * Silly method that subclass will try to override
	  *
	  * The attempt to override will "fail" in a weird way.
	  *
	  * @returns ???
	  */
	int bar();

	 /**
	  * Silly method that subclass will try to override
	  *
	  * The attempt to override will succeed this time.
	  *
	  * @returns ???
	  */
	int virtual duh();

}; // DO NOT FORGET THE SEMICOLON!!!

#endif