/*
 * main.cpp
 *
 * Testing application to show off how operator overloading affects memory.
 *
 * When you run this application, you will see that math operations create a lot
 * of copies.  Most of the time, this is okay, because the object is small.  It
 * not much worse than the overhead of returning an int from a function.  As we
 * show here, it is possible to optimize the process, but at the cost of
 * making the code harder to read.
 *
 * Walker M. White
 * February 6, 2015
 */

#include <stdio.h>
#include "point.h"

/**
 * Test out stack-based objects using normal operations
 *
 * Math operations create copies.  Every time we perform an math operation, it makes
 * a new object.  The result is a lot of copies!
 */
void test_copies() {
	// Put them both on the stack this time.
	Point p(1,2,3); 
	Point q(4,5,6);
	
	printf("\n");
	printf("p+q is %s\n",(p+q).toString().c_str());
	printf("\n");
	printf("p-q is %s\n",(p-q).toString().c_str());
	printf("\n");
	printf("p*4 is %s\n",(p*4).toString().c_str());
	printf("\n");
	printf("4*p is %s\n",(4*p).toString().c_str());
	printf("\n");
	printf("(p+q)*4 is %s\n",((p+q)*4).toString().c_str());
	printf("\n");
	p = q;
	printf("p is %s\n",p.toString().c_str());
	printf("\n");
}


/**
 * Test out stack-based objects with an object cache.
 *
 * If you want to avoid copying, you need to make an object cache that stores
 * the result of the computation every step of the way.  For small objects
 * it is not really faster.  All you are doing is keeping the stack from creating
 * extra variables when a temporary placeholder is good enough.
 */
void test_cache() {
	// Put them both on the stack this time.
	Point p(1,2,3); 
	Point q(4,5,6);
	Point r;
	
	printf("\n");
	r = p; r += q;
	printf("p+q is %s\n",r.toString().c_str());

	printf("\n");
	r = p; r -= q;
	printf("p-q is %s\n",r.toString().c_str());

	printf("\n");
	r = p; r *= 4;
	printf("p*4 is %s\n",r.toString().c_str());

	printf("\n");
	r = 4*(p);
	printf("4*p is %s\n",r.toString().c_str());

	printf("\n");
	r = p; r += q; r *= 4;
	printf("(p+q)*4 is %s\n",r.toString().c_str());

	printf("\n");
	p = q;
	printf("p is %s\n",p.toString().c_str());

	printf("\n");
}


/**
 * Main application function.
 */
int main() {
	test_copies();
	//test_cache();
	return 0;
}