/*
 * main.cpp
 *
 * Testing application to show off the smart pointers
 *
 * Walker M. White
 * February 6, 2015
 */

#include <stdio.h>
#include <memory>
#include "point.h"

/**
 * Helper function to show off smart pointer scope
 */
std::shared_ptr<Point> makepoint() {
	// These are on the heap but do not need to be deleted
	std::shared_ptr<Point> p = std::shared_ptr<Point>(new Point(1,2,3));
	std::shared_ptr<Point> q = std::make_shared<Point>(-1,0,1);
	
	return p;
}

/**
 * Main application function.
 */
int main() {
	std::shared_ptr<Point> p;		// Currently holds nothing

	printf("\n");
	printf("Calling helper function\n");
	p = makepoint();
	printf("Helper function complete\n");
	p = nullptr;
	printf("Smart pointer set to nullptr\n");
	
	return 0;
}