/*
 * stringfun.h
 *
 * These are the classic palindrome functions shown off in CS 1110. 
 * The purpose of them is to show off how namespaces work.
 *
 * This implementation includes the using command, which removes the
 * prefix when called, but NOT when defined.
 *
 * Walker M. White
 * February 6, 2016
 */
#include "stringfun.h"
#include <iostream>		  // cout
#include <locale>         // locale, isalpha

using namespace stringfun; // To remove the  prefix
using namespace std; 	   // To remove the  prefix


/** Returns: true if s is a palindrome */
bool stringfun::isPalindrome(string s) {
    // Base palindrome
    if (s.size() < 2) {
        return true;
    }
    
    // s has at least 2 characters
    return s[0] == s[s.size()-1] && isPalindrome(s.substr(1,s.size()-2));
}

/** Returns: true if s is a palindrome paying attention only to the letters */
bool stringfun::isPalindromeLoosely(string s) {
    return isPalindrome(depunct(s));
}

/** Returns: s but with everything that is not a letter removed */
string stringfun::depunct(string s) {
    if (s.size() == 0) {
        return s;
    }
    
    locale locale;
    
    if (not isalpha(s[0],locale)) {
        return depunct(s.substr(1));
	}
	    
    return s[0] + depunct(s.substr(1));
}

/** Testing function */
int main() {
	string s = "";
	cout << "\"" << s << "\" is a palindrome: " << isPalindrome(s) << endl;
	s = "B";
	cout << "\"" << s << "\" is a palindrome: " << isPalindrome(s) << endl;
	s = "BB";
	cout << "\"" << s << "\" is a palindrome: " << isPalindrome(s) << endl;
	s = "BA";
	cout << "\"" << s << "\" is a palindrome: " << isPalindrome(s) << endl;
	s = "BOB";
	cout << "\"" << s << "\" is a palindrome: " << isPalindrome(s) << endl;
	s = "BOA";
	cout << "\"" << s << "\" is a palindrome: " << isPalindrome(s) << endl;
	s = "amanaplanacanalpanama";
	cout << "\"" << s << "\" is a palindrome: " << isPalindrome(s) << endl;
	s = "a man, a plan, a canal, panama!";
	cout << "\"" << s << "\" is a palindrome: " << isPalindrome(s) << endl;
	cout << endl;
	
	s = "bob";
	cout << "Depuncting \"" << s << "\" gives: " << depunct(s) << endl;
	s = "bob111!";
	cout << "Depuncting \"" << s << "\" gives: " << depunct(s) << endl;
	s = "?b#o#b?";
	cout << "Depuncting \"" << s << "\" gives: " << depunct(s) << endl;
	s = "?2#3@?";
	cout << "Depuncting \"" << s << "\" gives: " << depunct(s) << endl;
	cout << endl;

	s = "amanaplanacanalpanama";
	cout << "\"" << s << "\" is a loose palindrome: " << isPalindromeLoosely(s) << endl;
	s = "a man, a plan, a canal, panama!";
	cout << "\"" << s << "\" is a loose palindrome: " << isPalindromeLoosely(s) << endl;
	s = "?2#3@?";
	cout << "\"" << s << "\" is a loose palindrome: " << isPalindromeLoosely(s) << endl;
	cout << endl;

	return 0;
}