/*
 * cornelltest.h
 *
 * This is the C++ equivalent to the cornelltest unit test module that we use in the
 * Python course. It has assert functions that will quit the application if they fail.
 * The error messages will also produce a stack trace, though the stack trace is C++
 * style, and may look very foreign to you.
 *
 * Unlike the other example code in this lecture, this module is VERY Unix specific.
 * The library "execinfo" is a GNU-specific library designed for Unix and OS X. I have
 * no idea if it works on Windows.
 *
 * Walker M. White
 * February 6, 2015
 */

// Prevent cyclical includes
#ifndef __CORNELLTEST__H_ 
#define __CORNELLTEST__H_

/**
 * Quit if expected and received differ
 *
 * The meaning of "differ" for this function is !=.  As a result, this 
 * assert function is not necessarily reliable when expected and received 
 * are of type "float".  You should use the function assert_floats_equal 
 * for that application.
 *
 * @param expected  The answer we should have gotten
 * @param received  What we actually got
 */
void assert_equals(int expected,int received);


/**
 * Quit if expected and received differ
 *
 * The meaning of "same" for this function is ==.  As a result, this 
 * assert function is not necessarily reliable when expected and received 
 * are of type "float".  You should use the function assert_not_floats_equal 
 * for that application.
 *
 * @param expected  The answer we do not want
 * @param received  What we actually got
 */
void assert_not_equals(int expected,int received);


/**
 * Quit if received is False.
 * 
 * @param received  What we actually got
 */
void assert_true(bool received);


/**
 * Quit if received is True.
 * 
 * @param received  What we actually got
 */
void assert_false(bool received);


/**
 * Quit if floats expected and received differ.
 *
 * Floats are compared to be within EPSILON of one another.  If they are farther
 * apart than this, this function produces an error.
 *
 * @param expected  The answer we should have gotten
 * @param received  What we actually got
 */
void assert_floats_equal(float expected, float received);


/**
 * Quit if floats expected and received are the same.
 *
 * Floats are compared to be within EPSILON of one another.  If they are within this
 * range, this function produces an error.
 *
 * @param expected  The answer we do not want
 * @param received  What we actually got
 */
void assert_floats_not_equal(float expected, float received);

#endif
