/*
 * a.cpp
 *
 * This is a base class to show off subclassing.
 *
 * Subclassing works mostly like you think it does UNTIL you try to use polymorphism.
 * Then you are in for an unpleasant surprise.
 *
 * Walker M. White
 * February 6, 2015
 */
#include <stdio.h>
#include "a.h"

/** 
 * Create a new A object
 *
 * Note the use of default parameters.
 *
 * @param x  The initial x-coordinate
 * @param y  The initial y-coordinate
 */
A::A(float x, float y) {
	printf("Creating A value (%4.2f, %4.2f) @address %p\n", x, y, this);
	this->x = x; this->y = y;
}


/** 
 * Create a new A object
 *
 * This is a copy constructor.  It takes the contents of A and puts them in B.
 *
 * @param obj  The object to copy
 */
A::A(const A& obj) {
	printf("Copying A value (%4.2f, %4.2f) @address %p\n", obj.x, obj.y, this);
	x = obj.x; y = obj.y;
}

/**
 * Delete an A object
 *
 * This is ONLY necessary if the object contains other array, objects, or 
 * assets that it must delete once it is deleted.
 */
A::~A() {
	printf("Deleting A value (%4.2f, %4.2f) @address %p\n", x, y, this);
}	 


/**
 * Silly method that will not be overridden.
 *
 * @returns ???
 */
int A::foo() {
	printf("Invocation of foo() in class A @address %p\n", this);
	return 42;
}


/**
 * Silly method that subclass will try to override
 *
 * The attempt to override will "fail" in a weird way.
 *
 * @returns ???
 */
int A::bar() {
	printf("Invocation of bar() in class A @address %p\n", this);
	return 9000;
}


/**
 * Silly method that subclass will try to override
 *
 * The attempt to override will succeed this time.
 *
 * @returns ???
 */
int A::duh() {
	printf("Invocation of duh() in class A @address %p\n", this);
	return -1;
}

