/*
 * main.cpp
 *
 * Testing application to show off the simple point class
 *
 * Walker M. White
 * February 6, 2015
 */

#include <stdio.h>
#include "point.h"

/**
 * Main application function.
 */
int main() {
	Point p(1,2,3); 				// Stack based object
	Point* q = new Point(4,5,6);	// Heap based object
	
	printf("\n");
	printf("p has x-coordinate %4.2f\n", p.x);
	printf("q has x-coordinate %4.2f\n", q->x); // Note the difference

	printf("\n");
	printf("p is the point %s\n",p.toString().c_str());
	printf("q is the point %s\n",q->toString().c_str()); // Look at this carefully

	printf("\n");
	printf("The distance between p and q is %4.2f\n",p.dist(*q));
	printf("The distance between q and p is %4.2f\n",q->dist(p));
	printf("\n");
	
	// If on the heap, you MUST DELETE IT
	delete q;
	
	return 0;
}