/*
 * main.cpp
 * 
 * This module shows off how closures work in C++.  You may need these for callback
 * functions, particularly in the Physics engine.
 *
 * Walker M. White
 * February 12, 2016
 */
#include <stdio.h>
#include <vector>
#include <string>
#include <unordered_map>


using namespace std;


/**
 * Tests out a variable capture by value
 */
void test_by_value() {
	printf("Starting test by value\n");	

	int x = 0;
	int y;
	
	std::function<int(int)> test = [=](int var) {
		return x+var;
	};
	
	x = 2;
	y = 3;
	printf("%d + %d = %d\n",x,y,test(y));

	x = 10;
	y = 5;
	printf("%d + %d = %d\n",x,y,test(y));

	printf("Ending test by value\n");	
}


/**
 * Tests out a variable capture by reference
 */
void test_by_reference() {
	printf("Starting test by reference\n");	

	int x = 0;
	int y;
	
	std::function<int(int)> test = [&](int var) {
		return x+var;
	};
	
	x = 2;
	y = 3;
	printf("%d + %d = %d\n",x,y,test(y));

	x = 10;
	y = 5;
	printf("%d + %d = %d\n",x,y,test(y));

	printf("Ending test by reference\n");	
}

/**
 * Demonstrate callback functions
 *
 * In this example we test out the difference with capture by value and capture
 * by reference.
 */
int main() {
	printf("Starting main\n\n");
	
	test_by_value();
	printf("\n");
	test_by_reference();

	printf("\nFinished main\n");
}