/*
 * stringfun.h
 *
 * These are the classic palindrome functions shown off in CS 1110. 
 * The purpose of them is to show off how namespaces work.
 *
 * Walker M. White
 * February 6, 2016
 */

// Prevent cyclical includes
#ifndef __STRINGFUN__H_ 
#define __STRINGFUN__H_

#include <string>

namespace stringfun {

	/** Returns: true if s is a palindrome */
	bool isPalindrome(std::string s);

	/** Returns: true if s is a palindrome paying attention only to the letters */
	bool isPalindromeLoosely(std::string s);

	/** Returns: s but with everything that is not a letter removed */
	std::string depunct(std::string s);
	
} // namespace ends
#endif