/*
 * stringfun.h
 *
 * These are the classic palindrome functions shown off in CS 1110. 
 * The purpose of them is to show off how namespaces work.
 *
 * This implementation does not have the using command.
 *
 * Walker M. White
 * February 6, 2016
 */
#include "stringfun.h"
#include <iostream>		  // std::cout
#include <locale>         // std::locale, std::isalpha


/** Returns: true if s is a palindrome */
bool stringfun::isPalindrome(std::string s) {
    // Base palindrome
    if (s.size() < 2) {
        return true;
    }
    
    // s has at least 2 characters
    return s[0] == s[s.size()-1] && isPalindrome(s.substr(1,s.size()-2));
}

/** Returns: true if s is a palindrome paying attention only to the letters */
bool stringfun::isPalindromeLoosely(std::string s) {
    return stringfun::isPalindrome(stringfun::depunct(s));
}

/** Returns: s but with everything that is not a letter removed */
std::string stringfun::depunct(std::string s) {
    if (s.size() == 0) {
        return s;
    }
    
    std::locale locale;
    
    if (not std::isalpha(s[0],locale)) {
        return stringfun::depunct(s.substr(1));
	}
	    
    return s[0] + stringfun::depunct(s.substr(1));
}

int main() {
	std::string s = "";
	std::cout << "\"" << s << "\" is a palindrome: " << stringfun::isPalindrome(s) << std::endl;
	s = "B";
	std::cout << "\"" << s << "\" is a palindrome: " << stringfun::isPalindrome(s) << std::endl;
	s = "BB";
	std::cout << "\"" << s << "\" is a palindrome: " << stringfun::isPalindrome(s) << std::endl;
	s = "BA";
	std::cout << "\"" << s << "\" is a palindrome: " << stringfun::isPalindrome(s) << std::endl;
	s = "BOB";
	std::cout << "\"" << s << "\" is a palindrome: " << stringfun::isPalindrome(s) << std::endl;
	s = "BOA";
	std::cout << "\"" << s << "\" is a palindrome: " << stringfun::isPalindrome(s) << std::endl;
	s = "amanaplanacanalpanama";
	std::cout << "\"" << s << "\" is a palindrome: " << stringfun::isPalindrome(s) << std::endl;
	s = "a man, a plan, a canal, panama!";
	std::cout << "\"" << s << "\" is a palindrome: " << stringfun::isPalindrome(s) << std::endl;
	std::cout << std::endl;
	
	s = "bob";
	std::cout << "Depuncting \"" << s << "\" gives: " << stringfun::depunct(s) << std::endl;
	s = "bob111!";
	std::cout << "Depuncting \"" << s << "\" gives: " << stringfun::depunct(s) << std::endl;
	s = "?b#o#b?";
	std::cout << "Depuncting \"" << s << "\" gives: " << stringfun::depunct(s) << std::endl;
	s = "?2#3@?";
	std::cout << "Depuncting \"" << s << "\" gives: " << stringfun::depunct(s) << std::endl;
	std::cout << std::endl;

	s = "amanaplanacanalpanama";
	std::cout << "\"" << s << "\" is a loose palindrome: " << stringfun::isPalindromeLoosely(s) << std::endl;
	s = "a man, a plan, a canal, panama!";
	std::cout << "\"" << s << "\" is a loose palindrome: " << stringfun::isPalindromeLoosely(s) << std::endl;
	s = "?2#3@?";
	std::cout << "\"" << s << "\" is a loose palindrome: " << stringfun::isPalindromeLoosely(s) << std::endl;
	std::cout << std::endl;

	return 0;
}