/*
 * Copyright (c) 1998 by Interdisciplinary Center Herzliya
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE INTERDISCIPLINARY CENTER HERZLIYA BE LIABLE
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND
 * ITS DOCUMENTATION, EVEN IF THE INTERDISCIPLINARY CENTER HERZLIYA
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE INTERDISCIPLINARY CENTER HERZLIYA SPECIFICALLY DISCLAIMS ANY
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE 
 * SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE
 * INTERDISCIPLINARY CENTER HERZLIYA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 * */

// $Header: /usr/u/raoul/cvs/cs415-storage-server/il/ac/idc/storage/Create.java,v 1.1.1.1 1999/09/17 18:07:28 raoul Exp $ 

package il.ac.idc.storage;

import java.io.*;

/** A CreateStorage Message. */
public class Create extends Message {
  public Credentials cred;
  public StorageID id;
  public long size;

  /** Create a Create message to be sent.
    *
    * @param c The credentials of the creator of the storage unit.
    * @param sid The StorageID of the newly created storage unit.
    * @param siz An estimate for the expected size of the storage unit.
    */
  public Create(Credentials c, StorageID sid, long siz) {
    marker = Message.Create;
    cred = c;
    id = sid;
    size = siz;
    uniq = 0;
  }

  /** Create a Create message to be sent.
    *
    * @param c The credentials of the creator of the storage unit.
    * @param sid The StorageID of the newly created storage unit.
    * @param siz An estimate for the expected size of the storage unit.
    */
  public Create(Credentials c, StorageID sid, long siz, int Uniq) {
    marker = Message.Create;
    cred = c;
    id = sid;
    size = siz;
    uniq = Uniq;
  }

  public String toString() {
    return "Create: " + id + ", " + size + " bytes" + ", u: " + uniq;
  }

  /** Create a Create message from a stream 
    *
    * @exception IOException Unable to read data to ostr
  */
  Create(DataInputStream istr) 
  throws IOException {
    marker = Message.Create;
    cred = new Credentials(istr.readLong());
    id = new StorageID(istr.readLong());
    size = istr.readLong();
    uniq = istr.readInt();
  }
  
  
  /** Transmit a Create packet over ostr. 
    *
    * @exception IOException Unable to write data to ostr
    */
  public void sendMessage(DataOutputStream ostr) 
    throws IOException {
    ostr.writeInt(marker);
    ostr.writeLong(cred.toLong()); 
    ostr.writeLong(id.toLong());
    ostr.writeLong(size);
    ostr.writeInt(uniq);
    ostr.flush();    
  }  
}
