/*
 * Copyright (c) 1998 by Interdisciplinary Center Herzliya
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE INTERDISCIPLINARY CENTER HERZLIYA BE LIABLE
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND
 * ITS DOCUMENTATION, EVEN IF THE INTERDISCIPLINARY CENTER HERZLIYA
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE INTERDISCIPLINARY CENTER HERZLIYA SPECIFICALLY DISCLAIMS ANY
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE 
 * SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE
 * INTERDISCIPLINARY CENTER HERZLIYA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 * */

// $Header: /usr/u/raoul/cvs/cs415-storage-server/il/ac/idc/storage/Bind.java,v 1.1.1.1 1999/09/17 18:07:28 raoul Exp $ 

package il.ac.idc.storage;

import java.io.*;

public class Bind extends Message {
  public Credentials cred;
  public StorageID dir;

  public String name;
  public StorageID id;

  /** Create a Bind message to be sent.
    *
    * @param c The Credentials of the message sender
    * @param d The StorageID of the directory in which the binding is to occur
    * @param nam The name to be bound
    * @param i The StorageID to which nam will be bound
    */
  public Bind(Credentials c, StorageID d, StorageID i, String nam) {
    marker = Message.Bind;
    cred = c;
    dir = d;
    name = nam;
    id = i;
    uniq = 0;
  }

  /** Create a Bind message to be sent.
    *
    * @param c The Credentials of the message sender
    * @param d The StorageID of the directory in which the binding is to occur
    * @param nam The name to be bound
    * @param i The StorageID to which nam will be bound
    * @param Uniq The uniqifier for this message
    */
  public Bind(Credentials c, StorageID d, StorageID i, String nam, int Uniq) {
    marker = Message.Bind;
    cred = c;
    dir = d;
    name = nam;
    id = i;
    uniq = Uniq;
  }

  public String toString() {
    return "Bind: (dir: " + dir + ") " + "\"" + name + "\"" + " to " + id
        + ", u: " + uniq;
  }

  /** Create a Bind message from a stream 
    * 
    * @param istr A DataInputStream containing the message in WireAPI
    * @exception IOException Unable to read Bind packet data from istr
    */
  Bind(DataInputStream istr) 
  throws IOException {
    int strlen;
    StringBuffer buff;

    marker = Message.Bind;
    cred = new Credentials(istr.readLong());
    dir = new StorageID(istr.readLong());

    id = new StorageID(istr.readLong());    
    uniq = istr.readInt();
    strlen = istr.readInt();
    buff = new StringBuffer();
    for (int i = 0; i <  strlen; i++) {
      buff.append(istr.readChar());
    }
    name = buff.toString();
  }
  
  /** Transmit a Bind packet over ostr. 
    *
    * @exception IOException Unable to write data to ostr
    */
  public void sendMessage(DataOutputStream ostr) 
    throws IOException {
    ostr.writeInt(marker);
    ostr.writeLong(cred.toLong()); 
    ostr.writeLong(dir.toLong());
    ostr.writeLong(id.toLong());
    ostr.writeInt(uniq);
    ostr.writeInt(name.length());
    ostr.writeChars(name);
    ostr.flush();    
  }  
}
