/*
 * Copyright (c) 1998 by Interdisciplinary Center Herzliya
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE INTERDISCIPLINARY CENTER HERZLIYA BE LIABLE
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND
 * ITS DOCUMENTATION, EVEN IF THE INTERDISCIPLINARY CENTER HERZLIYA
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE INTERDISCIPLINARY CENTER HERZLIYA SPECIFICALLY DISCLAIMS ANY
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE 
 * SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE
 * INTERDISCIPLINARY CENTER HERZLIYA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 * */

// $Header: /usr/u/raoul/cvs/cs415-storage-server/il/ac/idc/storage/Acknowledge.java,v 1.1.1.1 1999/09/17 18:07:28 raoul Exp $ 

package il.ac.idc.storage;

import java.io.*;

//
//
// WriteData
//
//
public class Acknowledge extends Message {
  public int data;

  /** Create an Acknowledge message to be sent.
    *
    * @param dat The error code to be returned
    */
  public Acknowledge(int dat) {
    marker = Message.Acknowledge;
    data = dat;
    uniq = 0;
  }

  /** Create an Acknowledge message to be sent.
    *
    * @param dat The error code to be returned
    */
  public Acknowledge(int dat, int Uniq) {
    marker = Message.Acknowledge;
    data = dat;
    uniq = Uniq;
  }

  /** Create an Acknowledge message object from a stream that
    * contains one in the wire protocol.  
    *
    * @exception IOException Unable to read acknowledgement code from istr
    */
  Acknowledge(DataInputStream istr) 
  throws IOException {
    marker = Message.Acknowledge;
    data = istr.readInt();
    uniq = istr.readInt();
  }
  
  /** Write the Acknowledgement message to DataOutputStream
    *
    * @param ostr the DataOutputStream to which the message is written
    * @exception IOException Unable to write packet to ostr
    */
  public void sendMessage(DataOutputStream ostr) 
    throws IOException {
    ostr.writeInt(marker);
    ostr.writeInt(data);
    ostr.writeInt(uniq);
    ostr.flush();    
  }

  public String toString() {
    return "Acknowledge: " + data + ", u: " + uniq;
  }  
}
