/*
 * Copyright (c) 1998 by Interdisciplinary Center Herzliya
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE INTERDISCIPLINARY CENTER HERZLIYA BE LIABLE
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND
 * ITS DOCUMENTATION, EVEN IF THE INTERDISCIPLINARY CENTER HERZLIYA
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE INTERDISCIPLINARY CENTER HERZLIYA SPECIFICALLY DISCLAIMS ANY
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE 
 * SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE
 * INTERDISCIPLINARY CENTER HERZLIYA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 * */

// $Header: /usr/u/raoul/cvs/cs415-storage-server/il/ac/idc/storage/server/BlockRecord.java,v 1.1.1.1 1999/09/17 18:07:28 raoul Exp $ 

package il.ac.idc.storage.server;
import il.ac.idc.storage.*;
import java.util.*;
import java.io.*;

/** Describe each block in a data storage unit. This class does not
 * contain the data of the block, that is maintain on the disk in this
 * implementation. Instead it indicates where the block can be found
 * on the disk, and any locking information about the block.  */
public class BlockRecord {
  /** The virtual address of the first byte of data in this block */
  public long virtualStart;
  /** The location in the disk file of the first byte of data in this block */
  public int physicalStart;
  /** The number of bytes of data in this block */
  public int length;
  public Credentials locker;
  public Date lockDate;
  
  /** Create a BlockRecord with the indicated parameters. 
      The locking information is left empty. */
  public BlockRecord(long vad, int pad, int size) {
    virtualStart = vad;
    physicalStart = pad;
    length = size;
  }

  /** Reads one block from a RandomAccessFile and 
      creates and returns a BlockRecord */
  public BlockRecord(DataInputStream file) 
  throws IOException {
    virtualStart = file.readLong();
    physicalStart = file.readInt();
    length = file.readInt();
    locker = new Credentials(file.readLong());
    lockDate = new Date(file.readLong());
  }

  public void writeBlock(DataOutputStream file) 
    throws IOException {
    file.writeLong(virtualStart);
    file.writeInt(physicalStart);
    file.writeInt(length);
    if (locker == null) {
      file.writeLong(0);
      file.writeLong(0);
    } else {
      file.writeLong(locker.toLong());
      file.writeLong(lockDate.getTime());
    }
  }

  public boolean setLock(Credentials who) 
  throws StorageException {
    if (locker == null) {
      locker = who;
      lockDate = new Date(System.currentTimeMillis());
      return true;
    } else {
      return false;
    }
  }
}

