/*
 * Copyright (c) 1998 by Interdisciplinary Center Herzliya
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE INTERDISCIPLINARY CENTER HERZLIYA BE LIABLE
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND
 * ITS DOCUMENTATION, EVEN IF THE INTERDISCIPLINARY CENTER HERZLIYA
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE INTERDISCIPLINARY CENTER HERZLIYA SPECIFICALLY DISCLAIMS ANY
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE 
 * SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE
 * INTERDISCIPLINARY CENTER HERZLIYA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 * */

// $Header: /usr/u/raoul/cvs/cs415-storage-server/il/ac/idc/storage/Credentials.java,v 1.1.1.1 1999/09/17 18:07:28 raoul Exp $ 

package il.ac.idc.storage;

/** Represents the unforgeable identity of a client.  Used to determine 
  * which operations are permitted a client.
  */
public class Credentials {
  long credentials;

  /** Create a Credentials object from the information contained in a 
    * packet.  This will need to be changed as the structure of the Credentials 
    * systems evolve.
  */
  public Credentials (long cred) {
    credentials = cred;
  }

  /** Create a human readable representation of a Credentials object.  
    * It may not be possible to reconstruct a Credentials object from 
    * its printed representation.
    *
    * @return a String that represents the Credentials
    */
  public String toString() {
    return "<Cred: " + credentials + ">";
  }

  public long toLong() {
    return credentials;
  }
}
