/*
 * Copyright (c) 1998 by Interdisciplinary Center Herzliya
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE INTERDISCIPLINARY CENTER HERZLIYA BE LIABLE
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND
 * ITS DOCUMENTATION, EVEN IF THE INTERDISCIPLINARY CENTER HERZLIYA
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE INTERDISCIPLINARY CENTER HERZLIYA SPECIFICALLY DISCLAIMS ANY
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE 
 * SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE
 * INTERDISCIPLINARY CENTER HERZLIYA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 * */

// $Header: /usr/u/raoul/cvs/cs415-storage-server/il/ac/idc/storage/WriteData.java,v 1.1.1.1 1999/09/17 18:07:27 raoul Exp $ 

package il.ac.idc.storage;

import java.io.*;

//
//
// WriteData
//
//
public class WriteData extends Message {
    // how much room there is to stick data on a WriteData message
    public static final int DATA_LENGTH = Message.UDPMessageSize - (2*4 + 4*8);
    //    public static final int DATA_LENGTH = Message.UDPMessageSize;

    public Credentials cred;
    public StorageID id;
    public long offset;
    public long length;
    public byte[] data;

    /** Create a WriteData message to be sent.
     */
    public WriteData(Credentials c, StorageID Id, long Offset, long Length, byte[] buff) {
        marker = Message.WriteData;
        cred = c;
        id = Id;
        offset = Offset;
        length = Length;
        data = buff;
        uniq = 0;
    }

    /** Create a WriteData message to be sent.
     */
    public WriteData(Credentials c, StorageID Id, long Offset, long Length, 
                     byte[] buff, int Uniq) {
        marker = Message.WriteData;
        cred = c;
        id = Id;
        offset = Offset;
        length = Length;
        data = buff;
        uniq = Uniq;
    }

    public String toString() {
        if (length < 100)
            return "WriteData (" + length + " bytes): " + id + " starting at " 
                + offset  + " data: " + Hexify.toHexString(data) + ", u: " + uniq;
        else
            return "WriteData (" + length + " bytes): " + id + " starting at " 
                + offset  + ", u: " + uniq;
    }

    public void sendMessage(DataOutputStream ostr) 
        throws IOException {
        ostr.writeInt(Message.WriteData);
        ostr.writeLong(cred.toLong()); 
        ostr.writeLong(id.toLong());
        ostr.writeLong(offset);
        ostr.writeLong(length);
        ostr.writeInt(uniq);
        ostr.write(data,0,(int)length);
        ostr.flush();    
    }

    /** Create a WriteData message from a stream */
    WriteData(DataInputStream istr) 
        throws IOException {
        marker = Message.WriteData;
        cred = new Credentials(istr.readLong());
        id = new StorageID(istr.readLong());
        offset = istr.readLong();
        length = istr.readLong();
        uniq = istr.readInt();
        data = new byte[(int)length];
        istr.read(data, 0, (int)length);
        //    for (int i = 0; i < length; i++) {
        //      data[i] = istr.readByte();
    }
}

