/*
 * Copyright (c) 1998 by Interdisciplinary Center Herzliya
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE INTERDISCIPLINARY CENTER HERZLIYA BE LIABLE
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND
 * ITS DOCUMENTATION, EVEN IF THE INTERDISCIPLINARY CENTER HERZLIYA
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE INTERDISCIPLINARY CENTER HERZLIYA SPECIFICALLY DISCLAIMS ANY
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE 
 * SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE
 * INTERDISCIPLINARY CENTER HERZLIYA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 * */

// $Header: /usr/u/raoul/cvs/cs415-storage-server/il/ac/idc/storage/Unbind.java,v 1.1.1.1 1999/09/17 18:07:27 raoul Exp $ 

package il.ac.idc.storage;

import java.io.*;

public class Unbind extends Message {
  public Credentials cred;
  public StorageID dir;

  public String name;

  /** Create a Unbind message to be sent.
  */
  public Unbind(Credentials c, StorageID d, String nam) {
    marker = Message.Unbind;
    cred = c;
    dir = d;
    name = nam;
    uniq = 0;
  }

  /** Create a Unbind message to be sent.
  */
  public Unbind(Credentials c, StorageID d, String nam, int Uniq) {
    marker = Message.Unbind;
    cred = c;
    dir = d;
    name = nam;
    uniq = Uniq;
  }

  public String toString() {
    return "Unbind: " + dir + ", the name " + name  + ", u: " + uniq;
  }

  /** Create a Unbind message from a stream */
  Unbind(DataInputStream istr) 
  throws IOException {
    int strlen;
    StringBuffer buff;

    marker = Message.Unbind;
    cred = new Credentials(istr.readLong());
    dir = new StorageID(istr.readLong());
    uniq = istr.readInt();

    strlen = istr.readInt();
    buff = new StringBuffer(strlen);
    for (int i = 0; i <  strlen; i++) {
      buff.setCharAt(i, istr.readChar());
    }
    name = buff.toString();
  }
  
  // Still have to send the data.
  public void sendMessage(DataOutputStream ostr) 
    throws IOException {
    ostr.writeInt(marker);
    ostr.writeLong(cred.toLong()); 
    ostr.writeLong(dir.toLong());
    ostr.writeInt(uniq);
    ostr.writeLong(name.length());
    ostr.writeChars(name);
    ostr.flush();    
  }  
}
