/*
 * Copyright (c) 1998 by Interdisciplinary Center Herzliya
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE INTERDISCIPLINARY CENTER HERZLIYA BE LIABLE
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND
 * ITS DOCUMENTATION, EVEN IF THE INTERDISCIPLINARY CENTER HERZLIYA
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE INTERDISCIPLINARY CENTER HERZLIYA SPECIFICALLY DISCLAIMS ANY
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE 
 * SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE
 * INTERDISCIPLINARY CENTER HERZLIYA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 * */

// $Header: /usr/u/raoul/cvs/cs415-storage-server/il/ac/idc/storage/StorageID.java,v 1.1.1.1 1999/09/17 18:07:27 raoul Exp $ 

package il.ac.idc.storage;

/** Represents the identifier of a Storage unit. This is really just a
 * wrapping of a 64 bit integer, but the wrapping provides additional
 * type declaration. 
 */
public class StorageID { 
  long storageID;
  public static StorageID none = new StorageID(0);
  
  public StorageID(int id) {
    storageID = (long)id;
  }
  
  public StorageID(long id) {
    storageID = id;
  }

  // It would be nice if this method would be used.
  public boolean equals(StorageID other) {
    return storageID == other.storageID;
  }

  public boolean equals(Object ob) {
    return 
	/* JDK 1.1 */ // StorageID.class.isInstance(ob) &&
	/* JDK 1.0 */ this.getClass() == ob.getClass() &&
	storageID == ((StorageID)ob).storageID;
  }

  /** Returns a long integer equivalent to the StorageID
    */
  public long toLong() {
    return storageID;
  }

  /** Returns the hashCode of a StorageID. Since the StorageID is a 
    * 64-bit integer, the hashCode is the XOR of the two halves of 
    * the StorageID, as is done in Long.hashCode.
    */
  public int hashCode() {
    return (int)(storageID^(storageID>>>32));
  }

  /** Return the next StorageID in this sequence. If the StorageID is 
    * for a data storage unit (i.e., positive), the next StorageID is 
    * one greater. For a directory storage unit, one less.
    */
  public StorageID next() {
    return new StorageID(storageID + (storageID < 0 ? -1 : 1));
  }

  public String toString() {
    return "<StrID: " + storageID +">";
  }

  /** Return true if the this storageID refers to data store
  */
  public boolean isDataStore() {
    return storageID > 0 ;
  }

  /** Return true if the this storageID refers to directory store
  */
  public boolean isDirectoryStore() {
    return storageID < 0;
  }
}

