/*
 * Copyright (c) 1998 by Interdisciplinary Center Herzliya
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE INTERDISCIPLINARY CENTER HERZLIYA BE LIABLE
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND
 * ITS DOCUMENTATION, EVEN IF THE INTERDISCIPLINARY CENTER HERZLIYA
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE INTERDISCIPLINARY CENTER HERZLIYA SPECIFICALLY DISCLAIMS ANY
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE 
 * SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE
 * INTERDISCIPLINARY CENTER HERZLIYA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 * */

// $Header: /usr/u/raoul/cvs/cs415-storage-server/il/ac/idc/storage/ReadData.java,v 1.1.1.1 1999/09/17 18:07:27 raoul Exp $ 

package il.ac.idc.storage;

import java.io.*;

public class ReadData extends Message {
  public Credentials cred;

  public StorageID id;
  public long offset;
  public long length;

  /** Create a ReadData message to be sent.
  */
  public ReadData(Credentials c, StorageID Id, long Offset, long Length) {
    marker = Message.ReadData;
    cred = c;
    id = Id;
    offset = Offset;
    length = Length;
    uniq = 0;
  }

  /** Create a ReadData message to be sent.
  */
  public ReadData(Credentials c, StorageID Id, long Offset, long Length, int Uniq) {
    marker = Message.ReadData;
    cred = c;
    id = Id;
    offset = Offset;
    length = Length;
    uniq = Uniq;
  }

  public String toString() {
    return "ReadData (" + length + " bytes): (" 
      + id + ") , starting at " + offset  + ", u: " + uniq;
  }

  public void sendMessage(DataOutputStream ostr) 
  throws IOException {
    ostr.writeInt(marker);
    ostr.writeLong(cred.toLong()); 
    ostr.writeLong(id.toLong());
    ostr.writeLong(offset);
    ostr.writeLong(length);
    ostr.writeInt(uniq);
    ostr.flush();
  }

  /** Create a ReadData message from a stream */
  ReadData(DataInputStream istr) 
  throws IOException {
    marker = Message.ReadData;
    cred = new Credentials(istr.readLong());
    id = new StorageID(istr.readLong());
    offset = istr.readLong();
    length = istr.readLong();
    uniq = istr.readInt();
  }
}
