package il.ac.idc.storage;
import java.io.*;

/** Utility for generating a formatted hex string from a byte array.
 */
public class Hexify {
    static char[] hexdigits = {'0','1','2','3','4','5','6','7','8',
			      '9','A','B','C','D','E','F'};

    public static String toHexString(byte[] buffer) {
        StringBuffer sbuf = new StringBuffer();
        int i, firstpart, secondpart;
        for (i=0; i<buffer.length; i++) {
            firstpart = (buffer[i] & 0xF0)>>4;
            secondpart = buffer[i] & 0x0F;
            sbuf.append(hexdigits[firstpart]);
            sbuf.append(hexdigits[secondpart]);
            if (i%2 == 1)
                sbuf.append(' ');
        }
        return sbuf.toString();
    }

    public static char toHexChar(int c){
	return hexdigits[c];
    }
}

