/*
 * Copyright (c) 1998 by Interdisciplinary Center Herzliya
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE INTERDISCIPLINARY CENTER HERZLIYA BE LIABLE
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND
 * ITS DOCUMENTATION, EVEN IF THE INTERDISCIPLINARY CENTER HERZLIYA
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE INTERDISCIPLINARY CENTER HERZLIYA SPECIFICALLY DISCLAIMS ANY
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE 
 * SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE
 * INTERDISCIPLINARY CENTER HERZLIYA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 * */

// $Header: /usr/u/raoul/cvs/cs415-storage-server/il/ac/idc/storage/Delete.java,v 1.2 1999/09/21 13:03:30 raoul Exp $ 

package il.ac.idc.storage;

import java.io.*;

public class Delete extends Message {
  public Credentials cred;
  public StorageID id;

  public long size;

  /** Create a Delete message to be sent.
  */
  public Delete(Credentials c, StorageID sid) {
    marker = Message.Delete;
    cred = c;
    id = sid;
    uniq=0;
  }

  /** Create a Delete message to be sent.
  */
  public Delete(Credentials c, StorageID sid, int Uniq) {
    marker = Message.Delete;
    cred = c;
    id = sid;
    uniq=Uniq;
  }

  public String toString() {
    return "Delete: " + id + ", u: " + uniq;
  }

  /** Create a Delete message from a stream */
  Delete(DataInputStream istr) 
  throws IOException {
    marker = Message.Delete;
    cred = new Credentials(istr.readLong());
    id = new StorageID(istr.readLong());
    size = istr.readLong();
    uniq = istr.readInt();  // BUG FIX by David Gutierrez
  }
  
  // Still have to send the data.
  public void sendMessage(DataOutputStream ostr) 
    throws IOException {
    ostr.writeInt(marker);
    ostr.writeLong(cred.toLong()); 
    ostr.writeLong(id.toLong());
    ostr.writeLong(size);
    ostr.writeInt(uniq);
    ostr.flush();    
  }
}
