/*
 * Copyright (c) 1998 by Interdisciplinary Center Herzliya
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE INTERDISCIPLINARY CENTER HERZLIYA BE LIABLE
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND
 * ITS DOCUMENTATION, EVEN IF THE INTERDISCIPLINARY CENTER HERZLIYA
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE INTERDISCIPLINARY CENTER HERZLIYA SPECIFICALLY DISCLAIMS ANY
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE 
 * SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE
 * INTERDISCIPLINARY CENTER HERZLIYA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 * */

// $Header: /usr/u/raoul/cvs/cs415-storage-server/il/ac/idc/storage/Debug.java,v 1.1.1.1 1999/09/17 18:07:28 raoul Exp $ 

package il.ac.idc.storage;

import java.io.*;

/** The Debug class provides error reporting methods. 
  * If debugging is true, then all debug messages are printed.
  * If debugging is false, then debug messages are only printed
  *    if their errorLevel is smaller than the debugLevel.
  */
public class Debug {
    public static boolean debugging = false;
    public static int debugLevel = 0;

    public static void print(String s) {
        if (debugging) {
            System.out.print(s);
        }
    }

    public static void println(int errorLevel, String s) {
        if (debugging || errorLevel <= debugLevel) {
            System.out.println(s);
        }
    }

    public static void showError(int errorLevel, String s, Exception e) {
        if (debugging || errorLevel <= debugLevel) {
            System.err.println(s);
            System.err.println("Message: " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    public static void println(String s) {
        if (debugging) {
            System.out.println(s);
        }
    }

    public static void showError(String s, Exception e) {
        if (debugging) {
            System.err.println(s);
            System.err.println("Message: " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }
}

