import il.ac.idc.storage.*;
import il.ac.idc.storage.server.*;
import java.io.*;

public class TestServer {
  public static void main (String argv[]) 
  throws IOException {
    Credentials c = new Credentials(0);
    String storageServerDir = null;

    if (argv.length != 1) {
      System.err.println("Usage: java TestServer <directory name>");
      System.exit(1);
    }
    storageServerDir = argv[0];

    try {
      Debug.println("========== Server Test ==========");

      if (new StorageID(3).equals(new StorageID(3))) {
      } else {
        Debug.println("Equal StorageID's are not equal");
      }
      
      System.out.println("Initializing storage server");

      SimpleStorageServer sss = new SimpleStorageServer(storageServerDir);
      StorageID sid = sss.createDataStore(c, 100);
      System.out.println("New DSU: " + sid); 
      
      byte[] 
        buffer = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9},
        buffer2 = {10, 11, 12, 13, 14, 15, 16, 17, 18, 19};
        
      byte[] inbuff;

      sss.writeData(c, sid, 0L, 10, buffer);
      
      sss.writeData(c, sid, 1000000000L, 10, buffer);

      for (long i = 0; i < 10; i++) {
        inbuff = sss.readData(c, new StorageID(sid.toLong()), i, 1);
        Debug.println("Location " + i + " contains: " + inbuff[0] 
                       + " (should be " + buffer[(int)i] + ")");
      }
      
      for (long i = 1000000000; i < 1000000010; i = i+2) {
        inbuff = sss.readData(c, sid, i, 2);
        Debug.println("Location " + i + " contains: " + (inbuff[0]<<8 + inbuff[1]) 
                       + " (should be " 
                       + (buffer[(int)(i-1000000000)]<<8 + buffer[(int)(i-1000000000)+1]) 
                       + ")");
      }
      sss.syncIndexes();

      StorageID dirID = sss.createDirectoryStore(c);
      Debug.println("Created a directory store: " + dirID);

      sss.bind(c, dirID, "TestFile", sid);
      StorageID fileID = sss.lookup(c, dirID, "TestFile");
      Debug.println("Looked up 'TestFile': " + fileID);

      sss.syncIndexes();
      System.out.println("\nPress return to quit");
      System.in.read();
      System.exit(0);
    }
    catch (StorageException e) {
      System.out.print(e.getMessage());
      Thread.currentThread().dumpStack();
      System.out.println("\nPress return to quit");
      System.in.read();
      System.exit(0);
    }
  }
}
