import il.ac.idc.storage.*;
import il.ac.idc.storage.client.*;
import java.io.*;
import java.net.*;

public class TestClient {
    static StorageServer server;

    public static void main (String args[]) 
	throws IOException {
	String serverName;
	Credentials c = new Credentials(0);

	if (args.length == 0) {
	    serverName = "localhost";
	} else if (args.length == 1) {
	    serverName = args[0];
	} else {
	    System.err.println("Improper number of arguments (" 
			       + args.length + "): TestClient server");
	    for (int i = 0; i < args.length; i++) {
		System.err.println("args[" + i + "] = " + args[i]);
	    }
	    Exit();
	    return;    // Just to keep the compiler quiet
	}

	try {
	    System.out.print("Client Test\n");
	    byte[] array = {0, 1, 2, 3, 4, 5};  // data that is to be written
	    byte[] answer;                      // Where data is to be store on reads
	    byte[] newTest = new byte[100];
      
	    // Create a storage server object.
	    server = 
		new ThreadsafeUDPStorageServer(InetAddress.getByName(serverName));

	    StorageID sid = server.createDataStore(c, 1024);
	    System.out.println("Created Storage Unit with ID" + sid);

	    // answer = server.readData(c, sid, 2, 4);
      
	    byte[] a = new byte[200];
	    byte[] b = new byte[WriteData.DATA_LENGTH];
	    byte[] x = new byte[WriteData.DATA_LENGTH+1];
	    
	    for (int i = 0; i<a.length; i++)
		a[i] = 1;
	    for (int i = 0; i<b.length; i++)
		b[i] = 2;
	    for (int i = 0; i<x.length; i++)
		x[i] = 2;
		
	    System.out.println("Array size: " + a.length);
	    server.writeData(c,sid,0,a.length,a);
	    server.writeData(c,sid,a.length,a.length,a);
	    // Writes completed
	    System.out.println("Writes completed");
	    byte[] d = server.readData(c,sid,0,a.length*2);

	    System.out.println(a.length*2 + " written, and " + d.length + " read.");

	    System.out.println("*** normal test resumes ***");

	    server.writeData(c, sid, 0, 100, newTest);

	    server.writeData(c, sid, 0, 6, array);
	    System.out.println("Wrote 6 bytes to StorageID: " + sid);

	    answer = server.readData(c, sid, 2, 4);
	    System.out.println("Read 4 bytes from StorageID: " + sid 
			       + ". Should be: 2345");
	    System.out.println("*** They are: " + answer[0]+ answer[1] + answer[2] 
			       + answer[3]); 
      
	    answer = server.readData(c, sid, 20, 4);
	    System.out.println("Read 4 bytes from StorageID:" + sid 
			       + ". Should be: 0000");
	    System.out.println("*** They are: " 
			       + answer[0]+ answer[1] + answer[2] + answer[3]);   

	    Exit();
	}
	catch (StorageException e) {
	    System.out.print("StorageError: " + e);
	}
    }

    static void Exit() {
	try {
	    System.out.println("\nPress return to quit");
	    System.in.read();
	} 
	catch (IOException e) {
	    System.err.println(e);
	}
	System.exit(-1);
    }
}
