import il.ac.idc.storage.*;
import il.ac.idc.storage.client.*;
import java.io.*;
import java.net.*;

public class NewClient {
    private static final int MAXSIZE = 1024;
    private static byte[] shadow = new byte[MAXSIZE];

    static StorageServer server;

    private static void writeSegment(Credentials c, StorageID sid,
				     int offset, int size) {
	byte[] buffer = new byte[size];
	byte value;

	for (int i = 0; i < size; i++) {
	    value = (byte) (i % 256);
	    buffer[i] = value;
	    shadow[offset + i] = value;
	}

	server.writeData(c,sid, offset, size, buffer);
    }

    private static void readSegment(Credentials c, StorageID sid,
				     int offset, int size) {
	byte[] buffer = server.readData(c, sid, offset, size);

	for (int i = 0; i < size; i++) {
	    if (buffer[i] != shadow[offset + i]) {
		System.err.println("write error at offset " + (offset + i));
		System.exit(1);
	    }
	}
	System.out.println("read result matches shadow buffer");
    }

    public static void main (String args[]) 
	throws IOException {
	String serverName;
	Credentials c = new Credentials(0);

	if (args.length == 0) {
	    serverName = "localhost";
	} else if (args.length == 1) {
	    serverName = args[0];
	} else {
	    System.err.println("Improper number of arguments (" 
			       + args.length + "): TestClient server");
	    for (int i = 0; i < args.length; i++) {
		System.err.println("args[" + i + "] = " + args[i]);
	    }
	    Exit();
	    return;    // Just to keep the compiler quiet
	}

	try {
	    System.out.print("Client Test\n");

	    server = 
		new ThreadsafeUDPStorageServer(InetAddress.getByName(serverName));
	    StorageID sid = server.createDataStore(c, MAXSIZE);
	    System.out.println("Created Storage Unit with ID" + sid);

	    writeSegment(c, sid, 1, 1);
	    writeSegment(c, sid, 3, 1);
	    writeSegment(c, sid, 0, 10);  // overlaps both previous segments
	    readSegment(c, sid, 0, 10);

	    writeSegment(c, sid, 100, 10);
	    writeSegment(c, sid, 90, 15);  // overlaps beginning of prev. seg.
	    readSegment(c, sid, 90, 20);

	    writeSegment(c, sid, 300, 20);
	    writeSegment(c, sid, 310, 20); // overlaps end of prev. seg.
	    readSegment(c, sid, 300, 30);

	    writeSegment(c, sid, 200, 1);
	    writeSegment(c, sid, 150, 17); // no overlap
	    readSegment(c, sid, 150, 17);
	    readSegment(c, sid, 200, 1);

	    Exit();
	}
	catch (StorageException e) {
	    System.out.print("StorageError: " + e);
	}
    }

    static void Exit() {
	try {
	    System.out.println("\nPress return to quit");
	    System.in.read();
	} 
	catch (IOException e) {
	    System.err.println(e);
	}
	System.exit(-1);
    }
}
