#ifndef __DISK_H__
#define __DISK_H__


#include <stdio.h>


#define DISK_BLOCK_SIZE 4096


typedef enum {
  DISK_READWRITE=0,
  DISK_READONLY=1
} disk_flags_t;

typedef struct {
  int size;    /* in blocks */
  int flags;
} disk_layout_t;

typedef struct {
  disk_layout_t layout;
  FILE* file;
} disk_t;


int
disk_create(disk_t* disk, char* name, int size, int flags);

int
disk_startup(disk_t* disk, char* name);

int
disk_shutdown(disk_t* disk);

void
disk_set_flags(disk_t* disk, int flags);

void
disk_unset_flags(disk_t* disk, int flags);

/* attempting to read from a new block before writing it may result in an
   error! */
int
disk_read_block(disk_t* disk, int blocknum, char* buffer);

int
disk_write_block(disk_t* disk, int blocknum, char* buffer);



#endif
