#include "minimsg.h"

enum routing_packet_type {
  ROUTING_DATA=0,
  ROUTING_ROUTE_DISCOVERY=1,
  ROUTING_ROUTE_REPLY=2
}

#define MAX_ROUTE_LENGTH 20
#define SIZE_OF_ROUTE_CACHE 20

/*
 * route_t encapsulates information about a route. The address of the source is stored
 * in the first position, and the address of the destination is stored in the last 
 * position.
 */
struct route_t {
  int len; /* length of the route, should be smaller than MAX_ROUTE_LENGTH */
  network_address_t path[MAX_ROUTE_LENGTH]; /* path along the route from path[0] to path[len-1] */
}

struct routing_header {
  routing_packet_type type; /* type of the routing packet */
  network_address_t destination;
  int seq_num; /* sequence number of the request */
  int ttl; /* number of hops until the packet is distroyed (time to live) if type is not ROUTING_DATA and the index in the route array of the current machine if the type is ROUTING_DATA */
  route_t route;
}

/*
 * miniroute_send_pkt returns the number of bytes sent if it was able to
 * successfully send the data.  Returns -1 otherwise.
 *
 * Before the packet can be sent a route has to be discovered. The route
 * cache is consulted for this purpose and if a route younger than 3 seconds
 * is not found the route discovery protocol is run. The function should return 
 * only when the packet is successfully sent (running the route discovery
 * protocol blocks the thread calling this function).
 *
 * All calls to network_send_pkt in the previous code should be replaced
 * with calls to this function instead.
 *
 */
int
miniroute_send_pkt(network_address_t dest_address,
		 int hdr_len, char * hdr,
		 int  data_len, char * data);


