#include "minithread.h"
#include "synch.h"

#include <stdlib.h>
#include <stdio.h>


#define N_ITERATIONS 10000
#define BUSY_WAIT 1000000


semaphore_t x, y;
int terminate = 0;

int
fast1(int* dummy) {
  while (!terminate) {
    printf("?");
    fflush(stdout); 
    semaphore_P(x);
    semaphore_V(y);
  }
   
  printf("\n");
  return 0;
}

int
fast2(int* dummy) {
  while (!terminate) {
    printf("!");
    fflush(stdout);
    semaphore_V(x);
    semaphore_P(y);
  }
   
  printf("\n");
  return 0;
}

int
slow(int* dummy) {
  int i, j;

  x = semaphore_create();
  y = semaphore_create();

  semaphore_initialize(x, 0);
  semaphore_initialize(y, 0);

  minithread_fork(fast1, NULL);
  minithread_fork(fast2, NULL);

  for (i=0; i<N_ITERATIONS; i++) {
    for (j=0; j<BUSY_WAIT; j++)
      ;
    printf(".");
  }

  terminate = 1;
  return 0;
}

int
main() {
  minithread_system_initialize(slow, NULL);
}
