/*
 * Alarm tester - register_alarm, deregister_alarm, 
 * minithread_sleep_with_timeout
 */

#include <stdio.h>
#include <stdlib.h>
#include <Time.h>
#include <string.h>

#include "minithread.h"
#include "synch.h"
#include "alarm.h"

extern register_alarm(int delay, void (*func)(void*), void *arg);
extern void deregister_alarm(int alarmid);
extern void minithread_sleep_with_timeout(int);

int temp;
int testthread(int* arg);
void alarmcall(void *p);
void alarmcall2(void *p);
void wait(long timeout);
long mytime();

void main (void){

  minithread_system_initialize(testthread, NULL);

}

int testthread(int* arg){
  int timeout;
  int i;
  int id;
		
  /* alarm test */
  temp = 0;
  timeout = 100;

  /* register_alarm */
  printf("\n\n1. Testing register_alarm..\n");
  for(i = 0; i <= 2; i++, timeout *= 10){
    printf("\nRegistering alarm for %d ms at %d ms.. ", timeout, mytime());
    id = register_alarm(timeout, alarmcall, "testing");
		
    wait(4*timeout);
    deregister_alarm(id);
  }

  /* deregister_alarm */
  printf("\n\n2. Testing deregister_alarm..\n");
  timeout = 1000;

  for(i = 0; i <= 1; i++, timeout *= 5){
    temp = 0;
    printf("\nRegistering alarm for %d ms..", timeout);
    id = register_alarm(timeout, alarmcall2, "testing");
    printf("deregistering alarm..");
    deregister_alarm(id);
				
    wait(2*timeout);

    if(temp == 0)
      printf("successfully deregistered\n");
    else printf("deregister failed\n");
  }

  printf("\n\n3. Testing minithread_sleep_with_timeout..\n");

  /* sleep with timeout test */
  timeout=100;
  for(i = 0; i <= 2; i++, timeout*=10){
    printf("\nMinithread sleeping at %d ms - for %d ms .. ", mytime(), timeout);
    minithread_sleep_with_timeout(timeout);
    printf("woke up at %d ms", mytime());
  }
  printf("\n");

  return 0;
}

void alarmcall(void *p){

  long now = mytime();

  if(strcmp(p, "testing") != 0)
    printf("param defect");
  else printf("called at %d ms", now);

}

void alarmcall2(void *p){

  temp = 1;
  printf("executed !\n");
	
}

/* return relative time in millisecs */
long mytime(){
  return ((long) clock());
}

/* wait for timeout millisecs */
void wait(long timeout){
  long now = mytime();
  int s=0;

  while(now+timeout > mytime()){
    int i; 

    for (i=0; i<=2000000; i++)
      s+=i;
  }
}
