/* implementation of the sieve of Eratosthenes

   Usage: sieve(<max-number-to-test>)
   will print out all the prime numbers less than or equal to the argument
*/

#include "minithread.h"
#include "synch.h"

#include <stdlib.h>
#include <stdio.h>


typedef struct {
  int value;
  semaphore_t produce;
  semaphore_t consume;
} channel_t;

typedef struct {
  channel_t* left;
  channel_t* right;
  int prime;
} filter_t;


int max;

/* produce all integers from 2 to max */
int source(int* arg) {
  channel_t* c = (channel_t *) arg;
  int i;

  for (i=2; i<=max; i++) {
    c->value = i;
    semaphore_V(c->consume);
    semaphore_P(c->produce);
  }
  
  c->value = -1;
  semaphore_V(c->consume);

  return 0;
}

int filter(int* arg) {
  filter_t* f = (filter_t *) arg;
  int value;

  for (;;) {
    semaphore_P(f->left->consume);
    value = f->left->value;
    semaphore_V(f->left->produce);
    if ((value == -1) || (value % f->prime != 0)) {
      f->right->value = value;
      semaphore_V(f->right->consume);
      semaphore_P(f->right->produce);
    }
    if (value == -1)
      break;
  }

  return 0;
}

int sink(int* arg) {
  channel_t* p = (channel_t *) malloc(sizeof(channel_t));
  int value;

  p->produce = semaphore_create();
  semaphore_initialize(p->produce, 0);
  p->consume = semaphore_create();
  semaphore_initialize(p->consume, 0);

  minithread_fork(source, (int *) p);
  
  for (;;) {
    filter_t* f;

    semaphore_P(p->consume);
    value = p->value;
    semaphore_V(p->produce);
    
    if (value == -1)
      break;

    printf("%d is prime.\n", value);
    
    f = (filter_t *) malloc(sizeof(filter_t));
    f->left = p;
    f->prime = value;
    
    p = (channel_t *) malloc(sizeof(channel_t));
    p->produce = semaphore_create();
    semaphore_initialize(p->produce, 0);
    p->consume = semaphore_create();
    semaphore_initialize(p->consume, 0);
    
    f->right = p;

    minithread_fork(filter, (int *) f);
  }

  return 0;
}

main(int argc, char** argv) {

  /* argument checking */
  if (argc <= 1) {
    printf("Error, integer argument required, exiting.\n");
    exit(-1);
  }

  max = atoi(argv[1]);

  if (max < 2) {
    printf("Error, argument must be at least 2, exiting.\n");
    exit(-2);
  }
  
  minithread_system_initialize(sink, NULL);
}
