#ifndef __QUEUE_H_
#define __QUEUE_H_

/* any_t is a pointer.  This allows you to put arbitrary structures on
   the queue as well as use the value to store data types that are
   smaller than sizeof(void *). */
typedef void *any_t;

/* PFany is a pointer to a function that can take two any_t arguments
   and return an integer. */
typedef int (*PFany)(any_t, any_t);

/* queue_t is a pointer to an internally maintained data structure.
   Clients of this package do not need to know how queues are
   represented.  They see and manipulate only queue_t's.  */
typedef any_t queue_t;

/*
 * queue manipulation functions  (you need to implement these)
 */

/* Return an empty queue. */
extern queue_t queue_new();

/* Prepend an any_t to a queue (both specifed as parameters).  Return
   0 (success) or -1 (failure). */
extern int queue_prepend(queue_t, any_t);

/* Appends an any_t to a queue (both specifed as parameters).  Return
   0 (success) or -1 (failure). */
extern int queue_append(queue_t, any_t);

/* Dequeue and return the first any_t from the queue or NULL if queue
   is empty.  Return 0 (success) or -1 (failure). */
extern int queue_dequeue(queue_t, any_t *);

/* Iterate the function parameter over each element in the queue.  The
   additional any_t argument is passed to the function as its first
   argument and the queue element is the second.  Return 0 (success)
   or -1 (failure). */
extern int queue_iterate(queue_t, PFany, any_t);

/* Free the queue and return 0 (success) or -1 (failure). */
extern int queue_free (queue_t);

#endif __QUEUE_H_

