#ifndef __MINITHREAD_X86_NT_H_
#define __MINITHREAD_X86_NT_H_

/*
 * Minithreads x86/NT Machine Dependent Code
 *
 * You should not need to modify this file.
 *
 */


#define MINITHREAD_VERSION 2


/* Used to initialize a thread's stack for the first context switch
 * to the thread.  The minithread_root procedure will be run with the
 * main and final procedures saved on the thread's stack
 */
typedef struct initial_stack_state {
    void *body_proc;            /* ebx */
    void *body_arg;             /* edi */
    void *finally_proc;         /* esi */
    void *finally_arg;          /* ebp */
    void *root_proc;            /* left on stack */

} *initial_stack_state_t;

typedef void *stack_pointer_t;

#define STACK_GROWS_DOWN        1
#define STACKSIZE               (64 * 1024)
#define STACKALIGN              03

#define TAS_LENGTH     3    /* 3 instructions in atomic_test_and_set */
#define INSTR_LENGTH   4    /* 4 bytes per instruction x86*/

#define MINITHREAD_ROOT         (void *) minithread_root

/*
 *  Returns the current time in milliseconds
 */
unsigned __int64 currentTimeMillis();

/*
 * minithread_switch - on the intel x86
 *
 */
extern void context_switch(stack_pointer_t *old_thread_sp,
			   stack_pointer_t *new_thread_sp);

#endif /* __MINITHREAD_X86_H_ */
