/* buffer.c

   bounded buffer

*/

#include <stdio.h>
#include <stdlib.h>

#include <sys/types.h>
#include <time.h>

#include "minithread.h"
#include "synch.h"


#define BUFFER_SIZE 16

int buffer[16];
int size, head, tail;

semaphore_t empty;
semaphore_t full;


int consumer(int* arg) {
  int n, i;
  int out = 0;

  while (out < *arg) {
    n = rand() % BUFFER_SIZE + 1;
    n = (n <= *arg - out) ? n : *arg - out;
    printf("Consumer wants to get %d items out of buffer ...\n", n);
    for (i=0; i<n; i++) {
      semaphore_P(empty);
      out = buffer[tail];
      printf("Consumer is taking %d out of buffer.\n", out);
      tail = (tail + 1) % BUFFER_SIZE;
      size--;
      semaphore_V(full);
    }
  }


  return 0;
}

int producer(int* arg) {
  int count = 1;
  int n, i;

  minithread_fork(consumer, arg);

  minithread_yield();

  while (count <= *arg) {
    n = rand() % BUFFER_SIZE + 1;
    n = (n <= *arg - count + 1) ? n : *arg - count + 1;
    printf("Producer wants to put %d items into buffer ...\n", n);
    for (i=0; i<n; i++) {
      semaphore_P(full);
      printf("Producer is putting %d into buffer.\n", count);
      buffer[head] = count++;
      head = (head + 1) % BUFFER_SIZE;
      size++;
      semaphore_V(empty);
    }
  }

  return 0;
}

main(int argc, char** argv) {
  int count;

  /* argument checking */

  if (argc <= 1) {
    printf("Error, integer argument required, exiting.\n");
    exit(-1);
  }
  
  count = atoi(argv[1]);

  if (count < 1) {
    printf("Error, argument must be at least 1, exiting.\n");
    exit(-2);
  }

  /* change this to srand(x) if you want to always want to start from x */
  srand(time(NULL)); 

  size = head = tail = 0;
  empty = semaphore_create();
  semaphore_initialize(empty, 0);
  full = semaphore_create();
  semaphore_initialize(full, BUFFER_SIZE);

  minithread_system_initialize(producer, &count);
}
