package edu.cornell.cs.cs4120.eth.etac.tester;

import edu.cornell.cs.cs4120.eth.FormattedOutput;
import edu.cornell.cs.cs4120.eth.SourceFileTest;

import java.io.File;
import java.io.PrintStream;

public class EtacExtensionTester extends EtacCodeGenTester {

    protected long elapsedCompile, elapsedExec;
    protected long accumCompile = 0, accumExec = 0;

    protected boolean isInvalidProgram(SourceFileTest t) {
        return !t.getExpectedFailures().isEmpty();
    }

    @Override
    public boolean copyReferenceFiles(SourceFileTest t, File testDir, File destDir) {
        if (isInvalidProgram(t))
            // Nothing to copy
            return true;
        return super.copyReferenceFiles(t, testDir, destDir);
    }

    @Override
    public boolean renameReferenceFiles(SourceFileTest t, File destDir) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean normalizeGeneratedFiles(SourceFileTest t, File destDir) {
        elapsedCompile = t.getCompilationTime();
        accumCompile += elapsedCompile;
        elapsedExec = 0;
        if (isInvalidProgram(t))
            // Nothing to normalize
            return true;
        return super.normalizeGeneratedFiles(t, destDir);
    }

    @Override
    protected int invokeExecutable(File exeFile, PrintStream ps, SourceFileTest t, File destDir) {
        // Start timer.
        long start = System.nanoTime();
        int result = super.invokeExecutable(exeFile, ps, t, destDir);
        // End timer.
        long finish = System.nanoTime();
        elapsedExec = finish - start;
        accumExec += elapsedExec;
        return result;
    }

    @Override
    public boolean checkResult(SourceFileTest t, File destDir) {
        t.appendNotice(String.format("Compilation time: %.3f ms", elapsedCompile / 1e6));
        if (isInvalidProgram(t)) {
            // Check if standard output has an error message.
            String stdout = t.getCompilerStdout();
            boolean okay = stdout != null && stdout.contains("error");
            if (!okay) t.appendFailureMessage("Error message expected");
            return okay;
        }
        t.appendNotice(String.format("Execution time: %.3f ms", elapsedExec / 1e6));
        return super.checkResult(t, destDir);
    }

    @Override
    public void printTestResult(SourceFileTest t, File destDir, FormattedOutput pr) {
        if (isInvalidProgram(t))
            // Nothing to report
            return;
        super.printTestResult(t, destDir, pr);
    }

    @Override
    public void getSummary(StringBuffer sb) {
        super.getSummary(sb);
        sb.append(String.format("\nTotal compilation time: %.3f ms", accumCompile / 1e6));
        sb.append(String.format("\nTotal execution time: %.3f ms", accumExec / 1e6));
    }
}
