package edu.cornell.cs.cs4120.eth.etac;

import edu.cornell.cs.cs4120.eth.ExpectedFailure;
import edu.cornell.cs.cs4120.eth.SourceFileTest;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.TimeUnit;

/** */
public class EtacSourceFileTest extends SourceFileTest {

    protected static final int TIMEOUT = 30;
    protected static final TimeUnit TIMEUNIT = TimeUnit.SECONDS;

    public EtacSourceFileTest(
            List<List<String>> compilationUnits, List<ExpectedFailure> expectedFailures) {
        super(compilationUnits, expectedFailures);
    }

    @Override
    protected boolean matchFilter() {
        return td.shouldExecute() && super.matchFilter();
    }

    @Override
    public EtacTestDriver getTestDriver() {
        return (EtacTestDriver) td;
    }

    @Override
    public int invokeCompiler(String compilerDirname, List<String> cmdLine) {
        //        edu.cornell.cs.cs4120.xic.Main.main(cmdLine.toArray(new String[cmdLine.size()]));
        //        return 0;

        String compilerCmd = "";
        File compilerDir = new File(compilerDirname);
        if (!compilerDir.isAbsolute()) {
            Path wd = Paths.get(".").toAbsolutePath();
            compilerCmd += wd.toString() + File.separator;
        }
        compilerCmd += compilerDirname + compilerName();
        // Check existence of compiler command
        File compiler = new File(compilerCmd);
        if (!compiler.isFile()) {
            appendFailureMessage("File " + compilerCmd + " does not exist.");
            return -3;
        }
        cmdLine.add(0, compilerCmd);
        ProcessBuilder pb = new ProcessBuilder(cmdLine);
        // Invoke compiler in work/path.
        File workDir = new File(td.getPathFromFlagMap("workpath"));
        pb.directory(workDir);

        Process p;
        try {
            p = pb.start();
        } catch (IOException e) {
            appendFailureMessage(this.compilerName() + " failed to start: " + e.getMessage());
            return -2;
        }

        try {
            if (waitOrDestroy(p)) {
                appendFailureMessage(this.compilerName() + " timed out and was killed");
                return -3;
            }
            InputStream outStream = p.getInputStream(); // normal output of the shell
            InputStream errStream = p.getErrorStream(); // error output of the shell
            try (InputStreamReader or = new InputStreamReader(outStream);
                    InputStreamReader er = new InputStreamReader(errStream);
                    BufferedReader osr = new BufferedReader(or);
                    BufferedReader esr = new BufferedReader(er)) {
                String line = null;
                sbout = new StringBuffer();
                while ((line = osr.readLine()) != null) {
                    sbout.append(line);
                    sbout.append('\n');
                }
                sberr = new StringBuffer();
                while ((line = esr.readLine()) != null) {
                    sberr.append(line);
                    sberr.append('\n');
                }
            }
            return p.exitValue();
        } catch (InterruptedException | IOException e) {
            appendFailureMessage("xth encountered an error while executing " + this.compilerName());
            e.printStackTrace();
            return -1;
        }
    }

    private boolean waitOrDestroy(Process p) throws InterruptedException {
        if (!p.waitFor(TIMEOUT, TIMEUNIT)) {
            p.descendants().forEach(ProcessHandle::destroyForcibly);
            p.destroyForcibly();
            return true;
        }
        return false;
    }

    @Override
    public String compilerName() {
        return getTestDriver().commandName();
    }
}
