package edu.cornell.cs.cs4120.eth.etac;

import edu.cornell.cs.cs4120.eth.BuildTest;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

/** */
public class EtacBuildTest extends BuildTest {

    public static final String BUILD_NAME = "etac-build";

    public EtacBuildTest() {
        super(BUILD_NAME);
    }

    @Override
    protected int invokeCompilerBuilder(File dir) {
        String buildCmd = dir.getAbsolutePath() + File.separator + BUILD_NAME;
        // Check existence of build command
        File builder = new File(buildCmd);
        if (!builder.isFile()) {
            appendFailureMessage("File " + buildCmd + " does not exist.");
            return -3;
        }
        ProcessBuilder pb = new ProcessBuilder(buildCmd);
        pb.directory(dir);
        pb.redirectErrorStream(true);
        try {
            Process p = pb.start();
            InputStream outStream = p.getInputStream(); // stdout and stderr of the shell
            try (InputStreamReader or = new InputStreamReader(outStream);
                    BufferedReader osr = new BufferedReader(or)) {
                String line;
                while ((line = osr.readLine()) != null) System.out.println(line);
            }
            return p.waitFor();
        } catch (InterruptedException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            return -1;
        } catch (IOException e) {
            appendFailureMessage(e.getMessage());
            return -2;
        }
    }
}
