package edu.cornell.cs.cs4120.eth;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;

/** */
public class ScriptTestSuite extends TestSuite<Test> {
    protected TestFactory tf;
    protected File scriptFile;
    protected boolean saveProblem = false;
    private boolean scriptLoaded = false;

    public ScriptTestSuite(TestFactory tf, String scriptFilename) {
        this(tf, new File(scriptFilename));
    }

    public ScriptTestSuite(TestFactory tf, File scriptFile) {
        super(scriptFile.getName());
        this.tf = tf;
        this.scriptFile = scriptFile;
        loadResults();
    }

    protected boolean loadScript() {
        if (scriptLoaded) return true;
        scriptLoaded = true;
        if (!scriptFile.exists()) {
            appendFailureMessage("File " + scriptFile.getName() + " not found.");
            return false;
        } else if (!parseScript()) return false;
        return true;
    }

    @Override
    protected boolean runTest() {
        saveProblem = false;
        if (!loadScript()) return false;

        // needed if test list gets updated after we set the controllers
        for (AbstractOutputController output : this.outputControllers) addOutputController(output);
        return super.runTest();
    }

    @Override
    protected void postIndividualTest() {
        if (!saveProblem) saveProblem = !saveResults();
    }

    @Override
    protected void postRun() {
        super.postRun();
        saveResults();
    }

    protected boolean parseScript() {
        Grm grm = new Grm(tf, scriptFile);
        try {
            List<Test> value = grm.parse().<List<Test>>value();
            tests = value;
        } catch (RuntimeException e) {
            throw e;
        } catch (Exception e) {
            // Used by CUP to indicate an unrecoverable error.
            e.printStackTrace(System.out);
            appendFailureMessage("Parsing error: " + e.getMessage());
            return false;
        }
        return true;
    }

    protected void loadResults() {
        try (ObjectInputStream ois =
                new ObjectInputStream(
                        new FileInputStream(TestSuiteResult.getResultsFileName(scriptFile)))) {
            TestResult tr = (TestResult) ois.readObject();
            setTestResult(tr);
        } catch (FileNotFoundException e) {
            // ignore, and fail silently
        } catch (ClassNotFoundException | IOException e) {
            System.err.println(
                    "Unable to load results for test suite " + getName() + ": " + e.getMessage());
        }
    }

    protected boolean saveResults() {
        try (ObjectOutputStream oos =
                new ObjectOutputStream(
                        new FileOutputStream(TestSuiteResult.getResultsFileName(scriptFile)))) {
            oos.writeObject(getTestSuiteResult());
        } catch (IOException e) {
            System.err.println("Unable to save results for test suite " + getName());
            return false;
        }
        return true;
    }

    @Override
    public List<Test> getTests() {
        loadScript();
        return super.getTests();
    }
}
