package edu.cornell.cs.cs4120.xth.xic.tester;

import edu.cornell.cs.cs4120.xth.FormattedOutput;
import edu.cornell.cs.cs4120.xth.SourceFileTest;

import java.io.File;

public interface XicTester {

    boolean copyReferenceFiles(SourceFileTest t, File testDir, File destDir);

    boolean renameReferenceFiles(SourceFileTest t, File destDir);

    boolean normalizeReferenceFiles(SourceFileTest t, File destDir);

    boolean normalizeGeneratedFiles(SourceFileTest t, File destDir);

    boolean checkResult(SourceFileTest t, File destDir);

    boolean cleanupReferenceFiles(SourceFileTest t, File destDir, File saveDir);

    boolean cleanupGeneratedFiles(SourceFileTest t, File destDir, File saveDir);

    void printTestResult(SourceFileTest t, File destDir, FormattedOutput pr);

    void getSummary(StringBuffer sb);
}
