package edu.cornell.cs.cs4120.xth;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class FormattedOutput extends AbstractOutputController {

    public abstract void printHeader(String header);

    public abstract void printText(String content);

    public abstract void printCode(File srcFile);

    public abstract void flush();

    private Pattern pattern =
            Pattern.compile("group_of_((\\p{Lower}+\\d+_)+(\\p{Lower}+\\d+))_(\\d+\\.|_[^/]+)");
    private int anonCounter;
    private Map<String, String> anonymizer = new HashMap<>();

    public String anonymizedName(String name) {
        Matcher matcher = pattern.matcher(name);
        Set<String> groupNames = new HashSet<>();
        while (matcher.find()) {
            String groupName = matcher.group(1);
            if (!anonymizer.containsKey(groupName)) {
                String anonymizedGroupName = "anonymous" + String.format("%02d", ++anonCounter);
                anonymizer.put(groupName, anonymizedGroupName);
            }
            groupNames.add(groupName);
        }
        for (String groupName : groupNames)
            name = name.replaceAll(groupName, anonymizer.get(groupName));
        return name;
    }
}
