#!/bin/bash
set -x
set -e

export DEBIAN_FRONTEND="noninteractive"

# basics - do not modify!
apt-get -qq update
apt-get -qq install \
  software-properties-common \
  python3-software-properties \
  dirmngr \
  pkg-config \
  wget \
  unzip \
  zip \
  dpkg \
  m4 \
  nano vim \
  ncdu \
  htop \
  xauth \
  x11-apps \
  gdb

# Oracle JDK 11 (LTS)
apt-get -qq install openjdk-11-jre openjdk-11-jdk

# Ant
apt-get -qq install ant

# Maven
apt-get -qq install maven

# Qt
apt-get -qq install cmake libqt4-dev libqt4-designer libqt4-opengl libqt4-svg libqtgui4 libqtwebkit4 libstdc++-4.8-dev g++

# C++
apt-get -qq install flex bison

# Gradle
GRADLE=gradle-5.1.1
GRADLEZIP=gradle-5.1.1-bin.zip
wget -nv -N https://services.gradle.org/distributions/$GRADLEZIP
unzip -d /opt/ $GRADLEZIP
ln -s /opt/$GRADLE/bin/gradle /usr/local/bin/
rm $GRADLEZIP

# Scala
SCALA=scala-2.12.8.deb
wget -nv -N www.scala-lang.org/files/archive/$SCALA
dpkg -i $SCALA &>/dev/null
apt-get -qq update  &>/dev/null
apt-get -qq install scala 2>/dev/null
rm "$SCALA"

# Scala sbt
echo "deb https://repo.scala-sbt.org/scalasbt/debian all main" | tee -a /etc/apt/sources.list.d/sbt.list
apt-key adv --keyserver hkp://keyserver.ubuntu.com:80 --recv 2EE0EA64E40A89B84B2DF73499E82A75642AC823
apt-get -qq update
apt-get -qq install sbt
sbt update

# Opam
add-apt-repository ppa:avsm/ppa
apt-get -qq update
apt-get -qq install opam

# Haskell dependencies
apt-get -qq install libgmp-dev libnuma-dev g++ gcc libc6-dev libffi-dev make xz-utils zlib1g-dev git gnupg

# scala gradle 6

mkdir /bin/gradle
cd /bin/gradle
wget https://services.gradle.org/distributions/gradle-6.1.1-bin.zip
unzip gradle-6.1.1-bin.zip
mv /bin/gradle/gradle-6.1.1/bin/gradle /bin/gradle/gradle-6.1.1/bin/gradle6
echo "export PATH=\$PATH:/bin/gradle/gradle-6.1.1/bin" >> ~/.bashrc
cd ~
mkdir tmp && cd tmp
cat << EOF | tee build.gradle
plugins {
    id 'scala'
}

dependencies {
    implementation 'org.scala-lang:scala-library:2.13.1'
}

repositories {
    mavenCentral()
}

scala {
    zincVersion = "1.3.3"
}
EOF
mkdir src && mkdir src/main && mkdir src/main/scala
cat << EOF | tee src/main/scala/hello.scala
object Hello {
    def main(args: Array[String]) = {
        println("Hello, world")
    }
}
EOF
/bin/gradle/gradle-6.1.1/bin/gradle6 build
cd ~ && rm -rf ~/tmp

# Node
curl -sL https://deb.nodesource.com/setup_14.x | bash -
apt-get -qq install nodejs
node -v

# Yarn
curl -sL https://dl.yarnpkg.com/debian/pubkey.gpg | sudo apt-key add -
echo "deb https://dl.yarnpkg.com/debian/ stable main" | tee /etc/apt/sources.list.d/yarn.list
apt-get -qq install yarn

# Kotlin
KOTLINC=kotlin-compiler-1.4.30
KOTLINCZIP=kotlin-compiler-1.4.30.zip
wget -nv -N https://github.com/JetBrains/kotlin/releases/download/v1.4.30/$KOTLINC.zip
unzip -d /opt/ $KOTLINCZIP
ln -s /opt/kotlinc/bin/kotlinc /usr/local/bin/

# see user-bootstrap.sh for more non-sudo bootstrapping
