/**
 Some exports to help write Xi bindings
*/
#ifndef LIBXI_H
#define LIBXI_H

#include "multret.h"
#include <stdint.h>
#include <stdio.h>

typedef int64_t xiint;
typedef int64_t xibool;
typedef xiint *xistring;

#define xilength(a) *(xiint *)((a)-1)

#ifdef __cplusplus
#define XI_EXPORT extern "C"
#else
#define XI_EXPORT
#endif

#if !defined(__CYGWIN__) && !defined(__APPLE__)
#define XI(x) _I ## x
#define XI_BUILTIN(x) _xi_ ## x
#else
#define XI(x) I ## x
#define XI_BUILTIN(x) xi_ ## x
/* On Cygwin/Windows (and apparently OS X) the compiler adds _ itself to
   everything; so we don't need one of our own */
#endif

// Main allocation hook
XI_EXPORT void * XI_BUILTIN(alloc)(xiint);

// Registers a finalizer for a given object
typedef void Finalizer(void*, void*);
XI_EXPORT void registerFinalizer(void*, Finalizer*);

extern xiint XI(parseInt_t2ibai)(xistring);
extern xistring XI(readln_ai)(void);
extern xistring XI(unparseInt_aii)(xiint);
extern xibool XI(eof_b)(void);
extern void XI(println_pai)(xistring);
extern void XI(print_pai)(xistring);

// Declare curses methods
extern void XI(initCurses_p)(void);
extern void XI(destroyCurses_p)(void);
extern void XI(showCurser_pb)(xibool);
extern xiint XI(getWindowSize_t2ii)(void);
extern xiint XI(getCurserPosition_t2ii)(void);
extern void XI(moveCurser_pii)(xiint, xiint);
extern void XI(echoKeys_pb)(xibool);
extern void XI(clearWindow_p)(void);
extern void XI(refreshWindow_p)(void);
extern void XI(inputTimeout_pi)(xiint);
extern xiint XI(getInputChar_i)(void);
extern xistring XI(getInputString_aii)(xiint);
extern void XI(putChar_pi)(xiint);
extern void XI(putString_pai)(xistring);
extern void XI(deleteChar_p)(void);
extern xiint XI(readChar_i)(void);
extern void XI(putCharAt_piii)(xiint, xiint, xiint);
extern void XI(putStringAt_paiii)(xistring, xiint, xiint);
extern void XI(deleteCharAt_pii)(xiint, xiint);
extern xiint XI(readCharAt_iii)(xiint, xiint);
extern xiint XI(KEYUP_i)(void);
extern xiint XI(KEYDOWN_i)(void);
extern xiint XI(KEYLEFT_i)(void);
extern xiint XI(KEYRIGHT_i)(void);

/** Helper functions **/

extern void printUcs4char(long int c, FILE *stream);
extern xistring mkString(const char* in);

#endif
// kate: indent-width 4; replace-tabs on; tab-width 4; space-indent on;
