import java_cup.runtime.Symbol;

%% definitions

%cup

%{
    static final int NUMBER = sym.NUMBER;

    class NumericLiteral extends Symbol {
        public NumericLiteral(int val) {
            super(NUMBER);
            value = val;
        }
    }
%}

Numeral = 0 | [1-9][0-9]*
Whitespace = [ \t\r\n]

%% rules start here

{Numeral}    { return new NumericLiteral(Integer.parseInt(yytext())); }
"+"          { return new Symbol(sym.PLUS); }
"*"          { return new Symbol(sym.TIMES); }
"("          { return new Symbol(sym.LPAREN); }
")"          { return new Symbol(sym.RPAREN); }
{Whitespace} {}

[^]          { throw new Error("Illegal character \"" + yytext() + "\""); }
