#!/bin/bash
set -x
set -e

command_exists () {
    type "$1" &> /dev/null ;
}

# put or link binaries here
BIN=$HOME/bin

# put things that should only be run once here
MARK=$HOME/.initialized
if [ ! -e $MARK ] ; then
  # add $BIN to PATH
  mkdir -p $BIN
  echo "PATH+=:$BIN" >> $HOME/.profile

  # nice prompt
  cat <<'EOF' >> $HOME/.profile
# Prompt
PROMPT_COMMAND="RET=$?; printf '\n'"
PS1="\[\e[0;32m\]\u\[\e[m\] \[\e[1;34m\]\w\[\e[m\]\[\e[0;32m\]$ \[\e[m\]"

# Aliases for convenience
alias grep='grep --color=always'
alias less='less -R'
alias ls="ls -G"

# update xth on login
~/xth/update
if [ -x ~/runtime/update ]; then
    ~/runtime/update
fi
if [ -x ~/QtXi/update ]; then
    ~/QtXi/update
fi
EOF

  # Jflex
  JFLEX="jflex-1.6.1"
  ARCHIVE="$JFLEX.tar.gz"
  wget -nv -N http://jflex.de/release/$ARCHIVE
  tar -zxf $ARCHIVE
  rm $ARCHIVE
  ln -sf $HOME/$JFLEX/bin/jflex $HOME/bin
  echo -e "\nexport JFLEX_HOME=$HOME/jflex/" >> $HOME/.profile

  # OCaml opam
  if command_exists opam ; then
    opam init -y #&>/dev/null
    eval `opam config env`
    echo '' >> $HOME/.profile
    echo '#OPAM' >> $HOME/.profile
    echo 'eval `opam config env`' >> $HOME/.profile

    # Oasis
    opam install -y oasis core &>/dev/null
  fi

  # Haskell - install ghcup, GHC, and cabal-install
  mkdir -p ~/.ghcup/bin
  curl -sSL https://raw.githubusercontent.com/haskell/ghcup/master/ghcup > ~/.ghcup/bin/ghcup
  chmod +x ~/.ghcup/bin/ghcup
  PATH+=:"$HOME/.cabal/bin:$HOME/.ghcup/bin:$PATH"
  echo 'PATH+=:"$HOME/.cabal/bin:$HOME/.ghcup/bin:$PATH"' >> $HOME/.profile
  ghcup install
  ghcup set
  ghcup install-cabal
  cabal new-update

  # Haskell stack - install to $BIN
  curl -sSL https://get.haskellstack.org/ | sh -s - -d $BIN

  # insecure SSH setup
  # https://www.vagrantup.com/docs/boxes/base.html
  mkdir -p ~/.ssh
  curl -sSL https://github.com/hashicorp/vagrant/raw/master/keys/vagrant.pub >> ~/.ssh/authorized_keys

  touch $MARK
  echo "VAGRANT: DO NOT REMOVE" >> $MARK
fi

WEBSEMESTER=2019sp

#Everything below will be used later in the semester

# test harness - do not modify!
XTH=xth.tar.gz
wget -nv -N http://www.cs.cornell.edu/courses/cs4120/$WEBSEMESTER/project/$XTH
mkdir -p xth
tar -zxf $XTH -C xth --owner=$USER
ln -sf $HOME/xth/xth $BIN

# runtime libraries - do not modify!
XIRT=runtime.zip
wget -nv -N -q http://www.cs.cornell.edu/courses/cs4120/$WEBSEMESTER/project/$XIRT && \
  mkdir -p runtime && \
  unzip -q $XIRT -d runtime && \
  (cd runtime ; cp -frp release/* . ; rm -rf release ; make) || \
true

# QtXi libraries - do not modify!
XIRT=QtXi.zip
wget -nv -N -q http://www.cs.cornell.edu/courses/cs4120/$WEBSEMESTER/project/$XIRT && \
  mkdir -p QtXi && \
  unzip -q $XIRT -d QtXi && \
  (cd QtXi ; cp -frp release/* . ; rm -rf release ; make) || \
true
