package edu.cornell.cs.cs4120.xth.xic.tester;

import java.io.File;

import edu.cornell.cs.cs4120.xth.PDFReporter;
import edu.cornell.cs.cs4120.xth.SourceFileTest;

public interface XicTester {

    boolean copyReferenceFiles(SourceFileTest t, File testDir, File destDir);

    boolean renameReferenceFiles(SourceFileTest t, File destDir);

    boolean normalizeReferenceFiles(SourceFileTest t, File destDir);

    boolean normalizeGeneratedFiles(SourceFileTest t, File destDir);

    boolean checkResult(SourceFileTest t, File destDir);

    boolean cleanupReferenceFiles(SourceFileTest t, File destDir, File saveDir);

    boolean cleanupGeneratedFiles(SourceFileTest t, File destDir, File saveDir);

    void printTestResult(SourceFileTest t, File destDir, PDFReporter pr);

    void getSummary(StringBuffer sb);
}
