package edu.cornell.cs.cs4120.xth.xic;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;

import edu.cornell.cs.cs4120.xth.SourceFileTest;
import edu.cornell.cs.cs4120.xth.SourceFileTestCollection;
import edu.cornell.cs.cs4120.xth.xic.tester.XicTester;

public class XicRefTestDriver extends XicTestDriver {

    protected static PrintStream nullPrintStream =
            new PrintStream(new OutputStream() {
                @Override
                public void write(int b) throws IOException {
                }
            });

    protected boolean haltOnFailure;

    public XicRefTestDriver(SourceFileTestCollection sftc) {
        this(sftc, false);
    }

    public XicRefTestDriver(SourceFileTestCollection sftc,
            boolean haltOnFailure) {
        super(sftc);
        this.haltOnFailure = haltOnFailure;
    }

    @Override
    public boolean haltOnFailure() {
        return haltOnFailure;
    }

    @Override
    public boolean preTest(SourceFileTest t) {
        // Run the reference compiler
        String refDirname = getPathFromFlagMap("refpath");
        List<String> cmdLineHdr = t.getCommandLineHeader();
        for (List<String> list : t.getSourceFileNames()) {
            List<String> cmdLine = new LinkedList<>(cmdLineHdr);
            cmdLine.addAll(list);

            // Suppress standard output.
            PrintStream stdout = System.out;
            System.setOut(nullPrintStream);

            try {
                // Invoke the compiler on the compilation unit.
                int ret = t.invokeCompiler(refDirname, cmdLine);
                if (ret != 0) {
                    t.appendFailureMessage("Failed to compile: "
                            + t.compilerName() + " exit code " + ret);
                    return false;
                }
            }
            finally {
                // Restore standard output.
                System.setOut(stdout);
            }
        }

        return super.preTest(t);
    }

    @Override
    protected boolean prepareReferenceFiles(XicTester tester,
            SourceFileTest t) {
        File destDir = getDestDir();
        return tester.renameReferenceFiles(t, destDir);
    }

    @Override
    protected boolean shouldCleanupReferenceFiles() {
        return true;
    }
}
